﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using NintendoWare.SoundFoundation.Core;

    /// <summary>
    /// サウンドセットドキュメントの読み込みをサポートします。
    /// </summary>
    public class SoundSetDocumentReaderCafe : SoundSetDocumentReaderCommon
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SoundSetDocumentReaderCafe(ObjectAggregateFactory<Type, Component> componentFactory)
            : base(componentFactory)
        {
            this.Platform = Platforms.Cafe.PlatformName;
            this.DocumentTypeName = Platforms.Cafe.SoundSetDocument;
            this.DocumentVersion = Platforms.Cafe.SoundSetDocumentVersion;
        }

        public override string GetFileVersion(string filePath)
        {
            return "0.0.0.0";
        }
    }
}
