﻿namespace NintendoWare.SoundFoundation.Projects
{
    using Nintendo.AudioToolkit.DomainModels;

    /// <summary>
    /// ウェーブサウンドクリップのコンバートモデルです。
    /// コンバートのために一時的にインスタンス生成されるだけで、編集には利用されません。
    /// </summary>
    public class WaveSoundClipConvertModel : Component
    {
        public WaveSoundClipConvertModel(WaveSoundClipResource model)
        {
            this.Model = model;
        }

        /// <summary>
        /// エンコード
        /// </summary>
        public WaveEncoding Encoding
        {
            get { return GetValue<WaveEncoding>(ProjectParameterNames.WaveEncoding); }
            set { SetValue<WaveEncoding>(ProjectParameterNames.WaveEncoding, value); }
        }

        public WaveSoundClipResource Model { get; private set; }

        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            SetInstanceParameterValue(ProjectParameterNames.WaveEncoding, new WaveEncodingParameterValue(WaveEncoding.Adpcm));
        }
    }
}
