﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NintendoWare.SoundFoundation.Operations
{
    public class ActionOperation : OperationImpl
    {
        public static ActionOperation CreateActionOperation<T>(T oldValue, T newValue, Action<T> action)
        {
            return new ActionOperation(() => action(newValue), () => action(oldValue));
        }

        private Action executeAction = null;
        private Action rollbackAction = null;

        public ActionOperation(Action executeAction, Action rollbackAction)
        {
            this.executeAction = executeAction;
            this.rollbackAction = rollbackAction;
        }

        protected override bool ExecuteInternal()
        {
            this.executeAction();
            return true;
        }

        protected override bool RollbackInternal()
        {
            this.rollbackAction();
            return true;
        }
    }
}
