﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using Nintendo.AudioToolkit.DataModels;
    using Nintendo.AudioToolKit.Xml;
    using NintendoWare.SoundFoundation.Projects;
    using System;
    using System.Linq;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Conversion;

    public class SoundSetModel2XmlTranslatorCommon : SoundSetModel2XmlTranslator
    {
        public SoundSetModel2XmlTranslatorCommon()
            : base(new SoundSetItemParamTranslatorCommon())
        {
            this.AddConverter<SoundSet, XmlSoundSetCommon>(this.SoundSetToXmlSoundSet);
            this.AddConverter<StreamSoundPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<WaveSoundSetPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SequenceSoundSetPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SequenceSoundPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SoundSetBankPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<PlayerPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<WaveArchivePack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<GroupPack, XmlSoundSetItemFolderCommon>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<StreamSound, XmlStreamSoundCommon>();
            this.AddConverter<StreamSoundTrack, XmlStreamSoundTrack>();
            this.AddConverter<WaveSoundSetBase, XmlWaveSoundSetCommon>();
            this.AddConverter<WaveSound, XmlWaveSoundCommon>();
            this.AddConverter<SequenceSoundSetBase, XmlSequenceSoundSetCommon>();
            this.AddConverter<SequenceSound, XmlSequenceSoundCommon>();
            this.AddConverter<SoundSetBank, XmlSoundSetBank>();
            this.AddConverter<PlayerBase, XmlPlayer>();
            this.AddConverter<WaveArchiveBase, XmlWaveArchive>();
            this.AddConverter<GroupBase, XmlGroup>();
            this.AddConverter<GroupItemBase, XmlGroupItem>();
        }

        new public XmlSoundSetCommon Run(SoundSet soundSet)
        {
            return this.Run<XmlSoundSetCommon>(soundSet) as XmlSoundSetCommon;
        }

        /// <summary>
        /// SoundSet から XmlSoundSet に変換します。
        /// </summary>
        /// <param name="src">変換元のオブジェクトを指定します。</param>
        /// <param name="dstType">変換後の型を指定します。</param>
        /// <param name="converter">変換の状態です。Converterから渡されます。</param>
        /// <returns>変換後のオブジェクトを返します。</returns>
        private object SoundSetToXmlSoundSet(object src, Type dstType, Converter converter)
        {
            Assertion.Argument.True(src is SoundSet);
            Assertion.Argument.True(dstType == typeof(XmlSoundSetCommon));

            var srcItem = src as SoundSet;
            var dest = new XmlSoundSetCommon();

            TranslateChildren(srcItem, dest, converter);

            var waveSoundResoucePairs = srcItem.ItemResources.Where(item => item.Value is WaveSoundResourceData);

            if (waveSoundResoucePairs.Any())
            {
                dest.ItemContents = new XmlSoundSetItemContentsCommon();

                // ドメインモデル ⇒ XML モデル変換
                waveSoundResoucePairs.ForEach(
                    pair =>
                    {
                        var waveSoundResourceData = (WaveSoundResourceData)pair.Value;
                        Ensure.Operation.True(waveSoundResourceData.Name == pair.Key);

                        dest.ItemContents.WaveSoundResources.Add(
                            WaveSoundResourceDataXml.FromDataModel(waveSoundResourceData));
                    });
            }

            return dest;
        }

        /// <summary>
        /// SoundSetItemPack から XmlSoundSetItemFolder に変換します。
        /// </summary>
        /// <param name="src">変換元のオブジェクトを指定します。</param>
        /// <param name="dstType">変換後の型を指定します。</param>
        /// <param name="converter">変換の状態です。Converterから渡されます。</param>
        /// <returns>変換後のオブジェクトを返します。</returns>
        private object SoundSetItemPackToXmlSoundSetItemFolder(object src, Type dstType, Converter converter)
        {
            Assertion.Argument.True(src is SoundSetItemPack);
            Assertion.Argument.True(dstType == typeof(XmlSoundSetItemFolderCommon));

            SoundSetItemPack srcItem = src as SoundSetItemPack;
            XmlSoundSetItemFolderCommon dest = new XmlSoundSetItemFolderCommon()
            {
                Name = srcItem.Name,
            };

            TranslateParameters(srcItem, dest, converter);
            TranslateChildren(srcItem, dest, converter);

            return dest;
        }
    }
}
