﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using Binarization;
    using Projects;

    internal class WaveEncoding2ByteConverter : TypeConverter<WaveEncoding, Byte>
    {
        private enum WaveFileWaveEncoding
        {
            Pcm8 = 0,
            Pcm16 = 1,
            Adpcm = 2,
            ImaAdpcm = 3,
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public override Byte ConvertTo(WaveEncoding value)
        {
            switch (value)
            {
                case WaveEncoding.Pcm8:
                case WaveEncoding.Pcm16:
                case WaveEncoding.Adpcm:
                case WaveEncoding.ImaAdpcm:
                    return (Byte)value;
            }

            throw new Exception("internal error : invalid WaveEncoding.");
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public override WaveEncoding ConvertFrom(Byte value)
        {
            switch ((WaveFileWaveEncoding)value)
            {
                case WaveFileWaveEncoding.Pcm8:
                case WaveFileWaveEncoding.Pcm16:
                case WaveFileWaveEncoding.Adpcm:
                case WaveFileWaveEncoding.ImaAdpcm:
                    return (WaveEncoding)value;
            }

            throw new Exception("internal error : invalid WaveEncoding.");
        }
    }
}
