﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterFilters : ParameterBytes
    {
        private const int LpfFrequencyIndex = 0;
        private const int BiquadTypeIndex = 1;
        private const int BiquadValueIndex = 2;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス ParameterBytes のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public Byte LpfFrequency
        {
            get { return this.Bytes[LpfFrequencyIndex]; }
            set { this.Bytes[LpfFrequencyIndex] = value; }
        }

        [DomIgnoreField]
        public Byte BiquadType
        {
            get { return this.Bytes[BiquadTypeIndex]; }
            set { this.Bytes[BiquadTypeIndex] = value; }
        }

        [DomIgnoreField]
        public Byte BiquadValue
        {
            get { return this.Bytes[BiquadValueIndex]; }
            set { this.Bytes[BiquadValueIndex] = value; }
        }
    }
}
