﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.Codec_ImaAdpcmInfo)]
    internal class ImaAdpcmInfo
    {
        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public Int16 OutPrevSample { get; set; }

        public Byte OutPrevTableIndex { get; set; }

        public Byte Padding { get; set; }

        public Int16 OutLoopPrevSample { get; set; }

        public Byte OutLoopPrevTableIndex { get; set; }

        public Byte Padding2 { get; set; }
    }
}
