﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "BinaryRoot", "Element" })]
    internal abstract class CommonFileRoot<THeader>
        where THeader : CommonFileHeader, new()
    {
        private THeader header = new THeader();
        private List<CommonBlock> blocks = new List<CommonBlock>();

        protected CommonFileRoot()
        {
            this.header.File = this;
        }

        protected CommonFileRoot(
            string signature,
            byte majorVersion, byte minorVersion, byte microVersion, byte binaryBugFixVersion)
            : this()
        {
            Ensure.Argument.NotNull(signature);

            this.header.Signature = signature;
            this.header.MajorVersion = majorVersion;
            this.header.MinorVersion = minorVersion;
            this.header.MicroVersion = microVersion;
            this.header.BinaryBugFixVersion = binaryBugFixVersion;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomField("Header")]
        public THeader Header
        {
            get { return this.header; }
        }

        [DomField("Blocks")]
        [EnumeratedField(typeof(CommonBlockNameProvider))]
        [DomPreAlignment(32)]
        public IList<CommonBlock> Blocks
        {
            get { return this.blocks; }
        }
    }
}
