﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.StreamSoundElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.StreamSoundFile_StreamSoundInfo)]
    internal class StreamSoundInfo
    {
        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomConvertTo(typeof(WaveEncoding2ByteConverter))]
        public WaveEncoding Encoding { get; set; }

        [DomConvertTo(typeof(Bool2ByteConverter))]
        public bool IsLoop { get; set; }

        public Byte ChannelCount { get; set; }

        public Byte RegionCount { get; set; }

        public UInt32 SamplingRate { get; set; }

        public UInt32 LoopStart { get; set; }

        public UInt32 LoopEnd { get; set; }

        public UInt32 BlockCount { get; set; }

        public UInt32 BlockSize { get; set; }

        public UInt32 SampleCountPerBlock { get; set; }

        public UInt32 LastBlockSize { get; set; }

        public UInt32 LastBlockSampleCount { get; set; }

        public UInt32 LastBlockPaddedLength { get; set; }

        public UInt32 SeekInformationSize { get; set; }

        public UInt32 SeekInformationIntervalSampleCount { get; set; }

        [DomObjectReference(
            OriginTag = "BinaryRoot", OriginPath = "Blocks/DATA/Body",
            HasType = true, HasOffset = true)]
        public ByteStream Data { get; set; }

        public UInt16 RegionInfoSize { get; set; }

        public UInt16 Padding
        {
            get { return 0; }
        }

        [DomObjectReference(
            OriginTag = "BinaryRoot", OriginPath = "Blocks/REGN/Body",
            HasType = true, HasOffset = true)]
        public RegionInfoArray RegionInfos { get; set; }

        public UInt32 OriginalLoopStart { get; set; }

        public UInt32 OriginalLoopEnd { get; set; }

        /// <summary>
        /// ストリームサウンドバイナリのハッシュ情報を取得します。
        /// ゲーム開発フロー中の事故などにより、bfstm と bfstp のリビジョンが食い違ってしまった場合に、
        /// atk ランタイムライブラリにて、それを検出するために利用されます。
        /// </summary>
        public StreamSoundHashInfo HashInfo { get; } = new StreamSoundHashInfo();
    }
}
