﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using Binarization;
    using Projects;
    using System;
    using System.Collections.Specialized;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential)]
    internal class ParameterSoundSinglePlay : IParameterValue
    {
        private BitVector32 data = new BitVector32(0);
        private BitVector32.Section section1, section2, section3, section4;

        private enum SinglePlayTypeValue : byte
        {
            None = 0,
            PrioritizeOldest,
            PrioritizeOldestEffectiveDuration,
            PrioritizeNewest,
            PrioritizeNewestEffectiveDuration,
        }

        public ParameterSoundSinglePlay()
        {
            section1 = BitVector32.CreateSection((short)byte.MaxValue);
            section2 = BitVector32.CreateSection((short)byte.MaxValue, section1);
            section3 = BitVector32.CreateSection(short.MaxValue, section2);
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public object Value
        {
            get { return (UInt32)(this.data.Data); }
        }


        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public SinglePlayType SinglePlayType
        {
            get { return this.ConvertByteToSinglePlayType((byte)this.data[this.section1]); }
            set { this.data[this.section1] = this.ConvertSinglePlayTypeToByte(value); }
        }

        [DomIgnoreField]
        public short EffectiveDuration
        {
            get { return (short)this.data[this.section3]; }
            set { this.data[this.section3] = value; }
        }

        [DomIgnoreField]
        object IParameterValue.Value
        {
            get { return this.Value; }
            set { throw new NotImplementedException(); }
        }

        private Byte ConvertSinglePlayTypeToByte(SinglePlayType value)
        {
            switch (value)
            {
                case SinglePlayType.None:
                    return (Byte)SinglePlayTypeValue.None;

                case SinglePlayType.PrioritizeOldest:
                    return (Byte)SinglePlayTypeValue.PrioritizeOldest;

                case SinglePlayType.PrioritizeOldestEffectiveDuration:
                    return (Byte)SinglePlayTypeValue.PrioritizeOldestEffectiveDuration;

                case SinglePlayType.PrioritizeNewest:
                    return (Byte)SinglePlayTypeValue.PrioritizeNewest;

                case SinglePlayType.PrioritizeNewestEffectiveDuration:
                    return (Byte)SinglePlayTypeValue.PrioritizeNewestEffectiveDuration;
            }

            throw new Exception("internal error : invalid SinglePlayType.");
        }

        private SinglePlayType ConvertByteToSinglePlayType(Byte value)
        {
            switch ((SinglePlayTypeValue)value)
            {
                case SinglePlayTypeValue.None:
                    return SinglePlayType.None;

                case SinglePlayTypeValue.PrioritizeOldest:
                    return SinglePlayType.PrioritizeOldest;

                case SinglePlayTypeValue.PrioritizeOldestEffectiveDuration:
                    return SinglePlayType.PrioritizeOldestEffectiveDuration;

                case SinglePlayTypeValue.PrioritizeNewest:
                    return SinglePlayType.PrioritizeNewest;

                case SinglePlayTypeValue.PrioritizeNewestEffectiveDuration:
                    return SinglePlayType.PrioritizeNewestEffectiveDuration;
            }

            throw new Exception("internal error : invalid SinglePlayType.");
        }
    }
}
