﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class SoundParameterArray : ParameterArray
    {
        private const int StringIDIndex = 0;
        private const int PanParamIndex = 1;
        private const int PlayerParamIndex = 2;
        private const int SinglePlayParamIndex = 3;
        private const int Sound3DIndex = 8;
        private const int SendIndex = 9;
        private const int ModulationIndex = 10;
        private const int FrontBypassIndex = 17;
        private const int UserParam3Index = 28;
        private const int UserParam2Index = 29;
        private const int UserParam1Index = 30;
        private const int UserParamIndex = 31;

        //-----------------------------------------------------------------
        // データ構造（複合パラメータ）
        //-----------------------------------------------------------------

        [DomField(IsOptional = true)]
        public ParameterSound3D Sound3D
        {
            get
            {
                ParameterReference<ParameterSound3D> value =
                    GetValue<ParameterReference<ParameterSound3D>>(Sound3DIndex);
                if (value == null) { return null; }
                return value.Value;
            }
            set
            {
                if (value == null)
                {
                    SetValue(Sound3DIndex, null);
                    return;
                }

                SetValue(Sound3DIndex, new ParameterReference<ParameterSound3D>(value));
            }
        }

        [DomField(IsOptional = true)]
        public ParameterUInt32 FrontBypass
        {
            get { return GetValue<ParameterUInt32>(FrontBypassIndex); }
            set { SetValue(FrontBypassIndex, value); }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public ParameterUInt32 StringID
        {
            get { return GetValue<ParameterUInt32>(StringIDIndex); }
            set { SetValue(StringIDIndex, value); }
        }

        [DomIgnoreField]
        public ParameterPanParam PanParam
        {
            get { return GetValue<ParameterPanParam>(PanParamIndex); }
            set { SetValue(PanParamIndex, value); }
        }

        [DomIgnoreField]
        public ParameterPlayerParam PlayerParam
        {
            get { return GetValue<ParameterPlayerParam>(PlayerParamIndex); }
            set { SetValue(PlayerParamIndex, value); }
        }

        [DomIgnoreField]
        public ParameterSoundSinglePlay SinglePlayParam
        {
            get { return GetValue<ParameterSoundSinglePlay>(SinglePlayParamIndex); }
            set { SetValue(SinglePlayParamIndex, value); }
        }

        [DomIgnoreField]
        public ParameterUInt32 UserParam
        {
            get { return GetValue<ParameterUInt32>(UserParamIndex); }
            set { SetValue(UserParamIndex, value); }
        }

        [DomIgnoreField]
        public ParameterUInt32 UserParam1
        {
            get { return GetValue<ParameterUInt32>(UserParam1Index); }
            set { SetValue(UserParam1Index, value); }
        }

        [DomIgnoreField]
        public ParameterUInt32 UserParam2
        {
            get { return GetValue<ParameterUInt32>(UserParam2Index); }
            set { SetValue(UserParam2Index, value); }
        }

        [DomIgnoreField]
        public ParameterUInt32 UserParam3
        {
            get { return GetValue<ParameterUInt32>(UserParam3Index); }
            set { SetValue(UserParam3Index, value); }
        }
    }
}
