﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.FileFormats.Binary;
    using NintendoWare.SoundFoundation.Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.SoundArchiveFile_StreamSoundTrackInfo)]
    internal class StreamSoundTrackInfo
    {
        public enum SurroundModeType : byte
        {
            Normal = 0,
            FrontBypass = 1,
            Preprocessed = 2,
        }

        //-----------------------------------------------------------------

        public StreamSoundTrackInfo()
        {
            this.GlobalChannelIndexTable = new EmbeddingTable<byte>();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public Byte Volume { get; set; }

        public Byte Pan { get; set; }

        public Byte SurroundPan { get; set; }

        public Byte SurroundMode { get; set; }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public EmbeddingTable<Byte> GlobalChannelIndexTableReference
        {
            get { return this.GlobalChannelIndexTable; }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public SendInfo SendInfoReference
        {
            get { return this.SendInfo; }
        }

        public Byte LpfFreqency { get; set; }

        [DomConvertTo(typeof(BiquadType2ByteConverter))]
        public BiquadType BiquadType { get; set; }

        public Byte BiquadValue { get; set; }

        public Byte Padding1 { get; set; }

        public EmbeddingTable<Byte> GlobalChannelIndexTable { get; private set; }

        /// <summary>
        /// 4 バイトアライメントのためのパディングです。
        /// </summary>
        public Byte[] Padding2
        {
            get
            {
                return new Byte[4 - (this.GlobalChannelIndexTable.ItemCount % 4)];
            }
        }

        public SendInfo SendInfo { get; set; }
    }
}
