﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.SoundArchiveFile_SoundGroupInfo)]
    internal sealed class SoundGroupInfo
    {
        public SoundGroupInfo()
        {
            this.SoundIDFirst = UInt32.MaxValue;
            this.SoundIDLast = UInt32.MaxValue;
            this.FileIDTable = new EmbeddingTable<UInt32>();
            this.Parameters = new SoundGroupParameterArray();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public BinaryItemID SoundIDFirst { get; set; }

        public BinaryItemID SoundIDLast { get; set; }

        [DomObjectReference(OriginTag = "Element", HasType = true, HasOffset = true)]
        public EmbeddingTable<UInt32> FileIDTableReference
        {
            get { return this.FileIDTable; }
        }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public object TypeDependentInfoReference
        {
            get { return this.TypeDependentInfo; }
        }

        public SoundGroupParameterArray Parameters { get; private set; }

        public EmbeddingTable<UInt32> FileIDTable { get; private set; }

        [DomField(IsOptional = true)]
        public object TypeDependentInfo { get; set; }
    }
}
