﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using NintendoWare.SoundFoundation.Binarization;
    using ToolDevelopmentKit;

    /// <summary>
    /// 共通ブロックの名前を取得するクラスです。
    /// </summary>
    internal class BinaryBlockNameProvider : IDomElementFieldNameProvider
    {
        /// <summary>
        /// DOM要素フィールド名を取得または設定します。
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 指定した値からDOM要素フィールド名を取得します。
        /// </summary>
        /// <param name="value">値を指定します。</param>
        /// <returns>DOM要素フィールドの名前を返します。</returns>
        public string GetNameFromValue(DomElement parent, object value)
        {
            Assertion.Argument.True(value is BinaryBlock);
            return (value as BinaryBlock).Header.Signature;
        }
    }
}
