﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class BinaryBlock
    {
        private BinaryBlockHeader header = new BinaryBlockHeader();
        private object body = null;

        public BinaryBlock()
        {
        }

        public BinaryBlock(string signature)
            : this()
        {
            Ensure.Argument.NotNull(signature);

            this.header.Signature = signature;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomField("Header")]
        public BinaryBlockHeader Header
        {
            get { return this.header; }
        }

        [DomField("Body")]
        public object Body
        {
            get { return this.body; }
            set
            {
                this.body = value;
                this.header.BodyReferenceForBodySize = value;
            }
        }
    }

    [StructLayout(LayoutKind.Sequential)]
    internal class BinaryBlock<TBody> : BinaryBlock
        where TBody : class
    {
        public BinaryBlock()
            : base()
        {
        }

        public BinaryBlock(string signature)
            : base(signature)
        {
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public new TBody Body
        {
            get { return base.Body as TBody; }
            set { base.Body = value; }
        }
    }
}
