﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.FileFormats
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Xml.Serialization;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;

    public class BankFileManager
    {
        private static BankFileManager InstanceInternal = new BankFileManager();

        private Dictionary<string, BankFileInfo> bankFiles = new Dictionary<string, BankFileInfo>();

        private BankFileManager() { }

        public static BankFileManager Instance
        {
            get { return BankFileManager.InstanceInternal; }
        }

        public BankFileInfo LoadFile(string filePath)
        {
            BankFileInfo bankFileInfo;
            string fullPath = filePath.GetFullPath();
            if (bankFiles.ContainsKey(fullPath))
            {
                bankFileInfo = bankFiles[fullPath];

                DateTime time = File.GetLastWriteTime(filePath);
                if (bankFileInfo.LastModifiedTime != time)
                {
                    if (!bankFileInfo.Open(filePath))
                    {
                        bankFiles.Remove(fullPath);
                        return null;
                    }
                }
            }
            else
            {
                bankFileInfo = new BankFileInfo();
                if (!bankFileInfo.Open(filePath))
                {
                    return null;
                }
                bankFiles[fullPath] = bankFileInfo;
            }

            return bankFileInfo;
        }

        public void Reload()
        {
            foreach (BankFileInfo bankFileInfo in bankFiles.Values)
            {
                DateTime time = File.GetLastWriteTime(bankFileInfo.FilePath);
                if (bankFileInfo.LastModifiedTime != time)
                {
                    if (!bankFileInfo.Open(bankFileInfo.FilePath))
                    {
                        bankFiles.Remove(bankFileInfo.FilePath);
                    }
                }
            }
        }

        public class BankFileInfo
        {
            private DateTime lastModifiedTime;
            private string filePath;
            private XmlBankFile bank;

            public DateTime LastModifiedTime
            {
                get { return lastModifiedTime; }
            }
            public string FilePath
            {
                get { return filePath; }
            }
            public XmlBankFile XmlBank
            {
                get { return bank; }
            }

            public bool Open(string filePath)
            {
                this.lastModifiedTime = File.GetLastWriteTime(filePath);

                using (FileStream fileStream = File.Open(filePath, FileMode.Open, FileAccess.Read, FileShare.Read))
                {
                    this.bank = new XmlSerializer(typeof(XmlBankFile)).Deserialize(fileStream) as XmlBankFile;
                }

                this.filePath = filePath;

                return true;
            }
        }
    }
}



