﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using Core.Collections;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    internal static class WaveArchiveEx
    {
        public static bool IsAutoGenerated(this WaveArchiveBase waveArchive)
        {
            Ensure.Argument.NotNull(waveArchive);
            return waveArchive.Name.EndsWith(SoundArchiveContext.AutoGeneratedNamePostfix);
        }

        public static ItemList GetItems(this WaveArchiveBase waveArchive)
        {
            Ensure.Argument.NotNull(waveArchive);

            if (!waveArchive.Parameters.ContainsKey(ConversionParameterNames.WaveArchive.Items))
            {
                waveArchive.Parameters.AddValue(
                    ConversionParameterNames.WaveArchive.Items,
                    new ObjectParameterValue<IList<Component>>(new ItemList()));
            }

            return waveArchive.Parameters[ConversionParameterNames.WaveArchive.Items].Value
                as ItemList;
        }

        public static OutputTargetList GetItemOutputTargets(this WaveArchiveBase waveArchive)
        {
            Ensure.Argument.NotNull(waveArchive);

            if (!waveArchive.Parameters.ContainsKey(ConversionParameterNames.WaveArchive.ItemOutputTargets))
            {
                waveArchive.Parameters.AddValue(
                    ConversionParameterNames.WaveArchive.ItemOutputTargets,
                    new ObjectParameterValue<OutputTargetList>(new OutputTargetList()));
            }

            return waveArchive.Parameters[ConversionParameterNames.WaveArchive.ItemOutputTargets].Value
                as OutputTargetList;
        }

        /// <summary>
        /// アイテムのインスタンス自身をキーとした番号付きアイテムリストです。
        /// </summary>
        public class ItemList : NumberedListDecorator<Component>
        {
            public ItemList()
                : base(new ObservableList<Component>())
            {
            }
        }

        /// <summary>
        /// アイテムの重複登録を許さない番号付き出力対象リストです。
        /// </summary>
        public class OutputTargetList : NumberedListDecorator<IOutput>
        {
            public OutputTargetList()
                : base(new ObservableList<IOutput>())
            {
            }
        }
    }
}
