﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.IO;
    using System.Text;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Collections;

    /// <summary>
    /// コンバートのファイル出力（成果物）を示すオブジェクトです。
    /// キャッシュ出力とは区別されます。
    /// 複数のファイル出力アイテムを１つの出力としてまとめます。
    /// </summary>
    internal class FileOutput : IOutput
    {
        private ObservableDictionary<string, IOutputItem> itemDictionary =
            new ObservableDictionary<string, IOutputItem>();

        private HashSet<string> dependenies = new HashSet<string>();

        /// <summary>
        /// 出力対象アイテム辞書を取得します。
        /// </summary>
        public IDictionary<string, IOutputItem> ItemDictionary
        {
            get { return this.itemDictionary; }
        }

        /// <summary>
        /// 依存ファイルパスの列挙子を取得します。
        /// </summary>
        public IEnumerable<string> DependentFilePaths
        {
            get { return this.dependenies; }
        }

        /// <summary>
        /// 出力が Dirty かどうかを調べます。
        /// </summary>
        public bool IsDirty
        {
            get
            {
                // 出力ファイルの存在確認
                foreach (IOutputItem item in this.itemDictionary.Values)
                {
                    if (!File.Exists(item.Path)) { return true; }

                    DateTime outputTime = File.GetLastWriteTime(item.Path);

                    // 依存ファイルの有効性確認
                    foreach (string dependedFilePath in this.dependenies)
                    {
                        if (outputTime.CompareTo(File.GetLastWriteTime(dependedFilePath)) < 0)
                        {
                            return true;
                        }
                    }
                }

                return false;
            }
        }

        private void OnItemDirectoryChanged(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch (e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    foreach (KeyValuePair<string, IOutputItem> item in e.NewItems)
                    {
                        if (!(item.Value is FileOutputItem))
                        {
                            throw new Exception("internal error : invalid output target.");
                        }
                    }
                    return;
            }

            throw new NotImplementedException("internal error : unexpected operation.");
        }
    }
}
