﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using System.IO;
    using FileFormats.NintendoWareBinary;
    using ToolDevelopmentKit;

    /// <summary>
    /// 波形アーカイブバイナリ DOM の構築をサポートします。
    /// </summary>
    internal class WaveArchiveFileBuilder
    {
        public WaveArchiveFileBuilder(string signature, BinaryVersion version)
        {
            Ensure.Argument.NotNull(signature);
            this.Signature = signature;
            this.Version = version;
        }

        public string Signature { get; set; }

        public BinaryVersion Version { get; set; }

        public WaveArchiveBinary Build(IEnumerable<Stream> waveStreams)
        {
            Ensure.Argument.NotNull(waveStreams);

            WaveArchiveBinary file = new WaveArchiveBinary(
                this.Signature,
                this.Version.Major,
                this.Version.Minor,
                this.Version.Micro,
                this.Version.BinaryBugFix);

            foreach (Stream waveStream in waveStreams)
            {
                file.AddItem(new ByteStream(waveStream));
            }

            return file;
        }
    }
}
