﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Projects;

    internal class RegisteringOutputInfo
    {
        private readonly Component targetComponent;
        private readonly IOutput targetOutput;
        private readonly string externalFileDirectoryPath;
        private readonly string outputFilePath;

        public RegisteringOutputInfo(Component targetComponent, IOutput targetOutput, string externalFileDirectoryPath, string outputFilePath)
        {
            this.targetComponent = targetComponent;
            this.targetOutput = targetOutput;
            this.externalFileDirectoryPath = externalFileDirectoryPath;
            this.outputFilePath = outputFilePath;
        }

        public Component TargetComponent
        {
            get { return this.targetComponent; }
        }

        public IOutput TargetOutput
        {
            get { return this.targetOutput; }
        }

        public string ExternalFileDirectoryPath
        {
            get { return this.externalFileDirectoryPath; }
        }

        public string OutputFilePath
        {
            get { return this.outputFilePath; }
        }
    }
}
