﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using Logs;
    using Projects;
    using ToolDevelopmentKit;

    internal class SequenceSoundNameResolver : SoundNameResolver<SequenceSoundBase>
    {
        public SequenceSoundNameResolver(ComponentDictionary componentDictionary)
            : base(componentDictionary)
        {
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="componentDictionary">コンポーネントディクショナリを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected override void RunInternal(
            SoundArchiveContext context, ComponentDictionary componentDictionary, SequenceSoundBase component)
        {
            base.RunInternal(context, componentDictionary, component);

            foreach (ComponentReference soundSetBankReference in component.SoundSetBankReferences)
            {
                // バンクの欠番を許す
                if (string.IsNullOrEmpty(soundSetBankReference.TargetName))
                {
                    continue;
                }

                SoundSetBankBase soundSetBank = componentDictionary.Contains(soundSetBankReference.TargetName) ?
                    componentDictionary[soundSetBankReference.TargetName][0] as SoundSetBankBase : null;

                if (soundSetBank == null || !soundSetBank.IsConvertTarget())
                {
                    context.Logger.AddLine(
                        new ErrorLine(
                            string.Format(Resources.MessageResource.Message_BankNotFound, soundSetBankReference.TargetName),
                            component)
                        );
                    return;
                }

                // メインサウンドアーカイブから追加サウンドアーカイブのバンクを参照している場合はエラーにする
                if (context.AddonSoundSet == null)
                {
                    // インゲーム編集時には追加サウンドアーカイブのアイテムを、
                    // メインサウンドアーカイブからコンバートしたものと同じようにランタイム側で扱うため、
                    // インゲーム編集で利用する部分コンバートではバンク参照をチェックしないようにする
                    if (context.Project.IsItemInAddonSoundArchive(soundSetBank) && !context.Settings.IsConvertParts)
                    {
                        context.Logger.AddLine(
                            new ErrorLine(
                                string.Format(Resources.MessageResource.Message_BankNotFoundInSoundArchive, soundSetBank.Name),
                                component)
                            );
                        return;
                    }
                }

                // サウンドセットバンクを参照していることを示します。
                soundSetBank.SetIsUsed(true);
            }
        }
    }
}
