﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 波形ファイルを参照するコンポーネントの依存ファイルをリンクします。
    /// </summary>
    internal class VelocityWaveDependedFileLinker : ComponentSetup<BankContext, VelocityRegion>
    {
        private FileManager fileManager;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="fileManager">ファイルマネージャを指定します。</param>
        public VelocityWaveDependedFileLinker(FileManager fileManager)
        {
            Ensure.Argument.NotNull(fileManager);
            this.fileManager = fileManager;
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(BankContext context, VelocityRegion component)
        {
            Assertion.Argument.NotNull(context);

            this.fileManager.RegisterDependedFile(
                component.GetOutputTarget(), component.GetFilePathForConvert());
        }
    }
}
