﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using Projects;
    using ToolDevelopmentKit;

    /// <summary>
    /// 対象となる型のコンポーネントを処理します。
    /// </summary>
    internal abstract class ComponentSetup<TContext, TComponent> : IComponentSetup
        where TContext : ConversionContext
        where TComponent : Component
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        public void Run(ConversionContext context, Component component)
        {
            Ensure.Argument.NotNull(context);
            Ensure.Argument.True(context is TContext);
            Ensure.Argument.True(component is TComponent);
            RunInternal(context as TContext, component as TComponent);
        }

        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected abstract void RunInternal(TContext context, TComponent component);
    }
}
