﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// コンポーネントを処理する ConversionProcessor です。
    /// </summary>
    public interface IComponentProcessor : IConversionProcessor
    {
        /// <summary>
        /// 依存するコンポーネントのコレクションを取得します。
        /// </summary>
        ICollection<Component> Components { get; }

        /// <summary>
        /// 関連するコンポーネントのコレクションを取得します。
        /// </summary>
        ICollection<Component> RelatedComponents { get; }
    }
}
