﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System;
    using System.Runtime.InteropServices;

    /// <summary>
    /// WaveCodec が生成する IMAADPCM 情報を格納します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct WaveCodecImaAdpcmData
    {
        public Int16 OutPrevSample;

        public Byte OutPrevTableIndex;

        public Byte Padding;

        public Int16 OutLoopPrevSample;

        public Byte OutLoopPrevTableIndex;

        public ImaAdpcmData ToAdpcmInformation()
        {
            return new ImaAdpcmData()
            {
                OutPrevSample = this.OutPrevSample,
                OutPrevTableIndex = this.OutPrevTableIndex,
                OutLoopPrevSample = this.OutLoopPrevSample,
                OutLoopPrevTableIndex = this.OutLoopPrevTableIndex,
            };
        }
    }
}
