﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using System.IO;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ADPCM サンプルを格納するパケットです。
    /// </summary>
    internal class AdpcmPacket : Packet
    {
        private byte[] seekInformation;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="samples">パケットに格納するサンプルを指定します。</param>
        public AdpcmPacket(byte[] samples)
            : this(samples, null)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="samples">パケットに格納するサンプルを指定します。</param>
        /// <param name="seekInformation">サンプルのシーク情報を指定します。</param>
        public AdpcmPacket(byte[] samples, byte[] seekInformation)
            : base(samples)
        {
            this.seekInformation = (seekInformation != null) ? seekInformation : new byte[0];
        }

        /// <summary>
        /// 格納されているサンプルのシーク情報を取得します。
        /// </summary>
        public byte[] SeekInformation
        {
            get { return this.seekInformation; }
        }

        /// <summary>
        /// パケットを生成します。
        /// </summary>
        /// <param name="samples">パケットに格納するサンプルを指定します。</param>
        /// <returns>生成したパケットを返します。</returns>
        public static new AdpcmPacket Create(byte[] samples)
        {
            return new AdpcmPacket(samples);
        }

        /// <summary>
        /// パケットを生成します。
        /// </summary>
        /// <param name="samples">パケットに格納するサンプルを指定します。</param>
        /// <param name="seekInformation">サンプルのシーク情報を指定します。</param>
        /// <returns>生成したパケットを返します。</returns>
        public static AdpcmPacket Create(byte[] samples, byte[] seekInformation)
        {
            return new AdpcmPacket(samples, seekInformation);
        }
    }
}
