﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Windows.Forms
{
    using System;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Core.Threading;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// WindowsFormsベースのIInvoker実装クラスです。
    /// </summary>
    public class FormsBasedInvoker : IInvoker
    {
        private Control invokeControl;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="invokeControl">
        /// Invoke 用のコントロールを指定します。
        /// null を指定すると、現在のスレッドで Invoke 用コントロールを作成します。
        /// </param>
        public FormsBasedInvoker(Control invokeControl)
        {
            if (invokeControl == null)
            {
                this.invokeControl = new Control();
                this.invokeControl.CreateControl();
            }
            else
            {
                this.invokeControl = invokeControl;
            }
        }

        /// <summary>
        /// 指定されたハンドラを非同期で実行します。
        /// </summary>
        /// <param name="handler">ハンドラを指定します。</param>
        /// <returns>結果にアクセスするための IAsyncResult を返します。</returns>
        public IAsyncResult BeginInvoke(Action handler)
        {
            Ensure.Argument.NotNull(handler);
            return this.invokeControl.BeginInvoke(handler);
        }

        /// <summary>
        /// 指定されたハンドラを実行します。
        /// </summary>
        /// <param name="handler">ハンドラを指定します。</param>
        public void Invoke(Action handler)
        {
            Ensure.Argument.NotNull(handler);
            this.invokeControl.Invoke(handler);
        }
    }
}
