﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    /// <summary>
    /// NumericTextBox の概要の説明です。
    /// </summary>
    public class NumericTextBox : System.Windows.Forms.TextBox
    {
        private int _Minimum = int.MinValue;
        private int _Maximum = int.MaxValue;
        private int _WheelValue = 1;
        private bool _Validate = true;
        private string _CurrentText = string.Empty;

        public event EventHandler Finished;

        ///--------------------------------
        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public NumericTextBox()
        {
            InitializeComponent();
        }

        protected override void OnEnter(EventArgs e)
        {
            _CurrentText = Text;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void OnLeave(EventArgs e)
        {
            Text = CheckAndRepairText(Text);
            base.OnLeave(e);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string Text
        {
            get { return base.Text; }
            set { base.Text = value; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public int Minimum
        {
            set { _Minimum = value; }
            get { return _Minimum; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public int Maximum
        {
            set { _Maximum = value; }
            get { return _Maximum; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public int WheelValue
        {
            set { _WheelValue = value; }
            get { return _WheelValue; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool Validate
        {
            set { _Validate = value; }
            get { return _Validate; }
        }

        ///--------------------------------
        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コンポーネント デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            components = new System.ComponentModel.Container();
        }
        #endregion

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void OnKeyDown(KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                Text = CheckAndRepairText(Text);
                if (Finished != null)
                {
                    Finished(this, new EventArgs());
                }
                e.Handled = true;

                return;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void OnKeyPress(System.Windows.Forms.KeyPressEventArgs e)
        {
            base.OnKeyPress(e);

            if (_Validate == false)
            {
                return;
            }

            //
            string text = null;

            switch (e.KeyChar)
            {
                case '-':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    text = Text;
                    text = text.Remove(SelectionStart, SelectionLength);
                    text = text.Insert(SelectionStart, e.KeyChar.ToString());
                    break;

                case (char)8:
                    text = Text;
                    break;

                default:
                    e.Handled = true;
                    return;
            }

            //単独で "-"が入力された状態なのか？
            //その場合には、数値判定を行わない
            if (text == "-")
            {
                return;
            }

            //
            Regex regex = new Regex(@"^([0]|([-]?[1-9][0-9]*))$");
            if (regex.IsMatch(text) == false)
            {
                e.Handled = true;
                return;
            }

            int value = -1;

            value = int.Parse(text);
            if (value < _Minimum || value > _Maximum)
            {
                e.Handled = true;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void OnMouseWheel(MouseEventArgs e)
        {
            base.OnMouseWheel(e);

            bool add = e.Delta >= 0 ? true : false;
            int relativeValue = (int)(Math.Abs(e.Delta) / 120);
            int value = 0;
            int addValue = 0;

            try
            {
                value = int.Parse(Text);
                addValue = _WheelValue * relativeValue;

                //減算なのか？
                if (add == false)
                {
                    value -= addValue;
                    if (value < _Minimum)
                    {
                        value = _Minimum;
                    }
                }
                else
                {

                    value += addValue;
                    if (value > _Maximum)
                    {
                        value = _Maximum;
                    }
                }

                Text = value.ToString();
                SelectAll();
            }
            catch { }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private string CheckAndRepairText(string text)
        {
            int ivalue;

            if (int.TryParse(text, out ivalue) == false || (ivalue < _Minimum ||
                                                                _Maximum < ivalue))
            {
                text = _CurrentText;
            }

            return text;
        }
    }
}
