﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public partial class NForm : Form
    {
        public NForm()
        {
            // プロパティの初期化
            base.DoubleBuffered = true;

            InitializeComponent();
        }

        #region ** プロパティのオーバーライド

        /// <summary>
        /// ちらつきを軽減または回避するために、2 次バッファを使用してコントロールの表面を再描画するかどうかを示す値を取得または設定します。
        /// </summary>
        [DefaultValue(true)]
        protected override bool DoubleBuffered
        {
            get { return base.DoubleBuffered; }
            set { base.DoubleBuffered = value; }
        }

        #endregion

        #region ** イベントハンドラのオーバーライド

        protected override void OnPaint(PaintEventArgs e)
        {
            e.Graphics.FillRectangle(new SolidBrush(BackColor), ClientRectangle);
            base.OnPaint(e);
        }

        protected override void OnPaintBackground(PaintEventArgs e)
        {
            // ちらつき軽減のため、デフォルトの処理を行わない。
            // 背景は OnPaint にて描画する
        }

        #endregion
    }
}
