﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.ComponentModel;
    using NintendoWare.SoundFoundation.Core;

    /// <summary>
    /// コンポーネントのインスタンス特性を管理します。
    /// </summary>
    public class SoundComponentTraits
    {
        /// <summary>
        /// サウンドプロジェクトのコンポーネントを取得します。
        /// </summary>

        public ObjectAggregateFactory<Type, Component> SoundProjectComponentFactory
        {
            get;
            protected set;
        }

        public ObjectAggregateFactory<Type, Component> SoundSetComponentFactory
        {
            get;
            protected set;
        }

        public ObjectAggregateFactory<Type, Component> BankComponentFactory
        {
            get;
            protected set;
        }
    }
}
