﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.ToolDevelopmentKit;

    public sealed class SendsParameterValue : ComplexParameterValue<Sends>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public SendsParameterValue(Sends value)
            : base(value)
        {
            SetParameterAttributes(nameof(ProjectParameterNames.Sends.MainSend), ParameterAttributes.ComputeHash);
            SetParameterAttributes(nameof(ProjectParameterNames.Sends.AuxASend), ParameterAttributes.ComputeHash);
            SetParameterAttributes(nameof(ProjectParameterNames.Sends.AuxBSend), ParameterAttributes.ComputeHash);
        }

        /// <summary>
        /// XML シリアライズ時の要素名を取得します。
        /// </summary>
        protected override string XmlElementName
        {
            get
            {
                return ProjectParameterNames.Sound.Sends;
            }
        }

        /// <summary>
        /// パラメータの値を取得するキャストオペレータです。
        /// </summary>
        /// <param name="value">対象となるパラメータ値を指定します。</param>
        /// <returns>パラメータの値を返します。</returns>
        public static implicit operator Sends(SendsParameterValue value)
        {
            Ensure.Argument.NotNull(value);
            return value.Value;
        }
    }
}
