﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using Parameters;

    public static class ProjectParameterNames
    {
        public const string ParameterKeySeparator = "/";
        private const string Sep = ParameterKeySeparator;

        public const string FilePath = "FilePath";
        public const string Comment = "Comment";
        public const string Comment1 = "Comment1";
        public const string Comment2 = "Comment2";
        public const string Comment3 = "Comment3";
        public const string Comment4 = "Comment4";
        public const string Comment5 = "Comment5";
        public const string Comment6 = "Comment6";
        public const string Comment7 = "Comment7";
        public const string Comment8 = "Comment8";
        public const string Comment9 = "Comment9";
        public const string UserParameter = "UserParameter";
        public const string UserParameter1 = "UserParameter1";
        public const string UserParameter2 = "UserParameter2";
        public const string UserParameter3 = "UserParameter3";
        public const string ColorIndex = "ColorIndex";
        public const string EnvelopeParams = "Envelope";
        public const string GroupItemRegisterType = "GroupItemRegisterType";
        public const string IsEnabled = "IsEnabled";
        public const string ID = "ID";
        public const string Name = "Name";
        public const string Pan = "Pan";
        public const string PanCurve = "PanCurve";
        public const string PanMode = "PanMode";
        public const string Pitch = "Pitch";
        public const string SurroundPan = "SurroundPan";
        public const string FrontBypass = "FrontBypass";
        public const string TargetItemReference = "TargetItemReference";
        public const string TargetName = "TargetName";
        public const string Volume = "Volume";
        public const string WaveEncoding = "WaveEncoding";
        public const string DataSize = "DataSize";
        public const string LPF = "LPF";
        public const string BiquadType = "BiquadType";
        public const string Biquad = "Biquad";
        public const string IntegratedLoudnessStatus = "IntegratedLoudnessStatus";
        public const string IntegratedLoudness = "IntegratedLoudness";

        public const string SndEdit = "SndEdit";
        public const string SndEditEnabled = "SndEditEnabled";

        public const string WaveTime = "WaveTime";
        public const string WaveTick = "WaveTick";
        public const string SampleRate = "SampleRate";
        public const string WaveBitRate = "WaveBitRate";
        public const string WaveSampleBit = "WaveSampleBit";
        public const string WaveChannel = "WaveChannel";
        public const string IsResampleEnabled = "IsResampleEnabled";
        public const string IsDownMixEnabled = "IsDownMixEnabled";

        // コンバート設定
        public static class Conversion
        {
            public const string DoWarnUnreferencedItems = "DoWarnUnreferencedItems";
            public const string DoWarnDisableGroupItemTargets = "DoWarnDisableGroupItemTargets";
            public const string DoWarnPCBinariesForAACNotFound = "DoWarnPCBinariesForAACNotFound";
            public const string ExcludeStringTable = "ExcludeStringTable";
            public const string DoOutputPCBinariesForAAC = "DoOutputPCBinariesForAAC";
            public const string DoUseHardwareOpusDecoder = "DoUseHardwareOpusDecoder";
            public const string DoDeleteGarbageOutputBinaries = "DoDeleteGarbageOutputBinaries";
            public const string ExternalFileDirectoryPath = "ExternalFileDirectoryPath";
            public const string UserManagementFileDirectoryPath = "UserManagementFileOutputDirectoryPath";
            public const string IntermediateOutputDirectoryPath = "IntermediateOutputDirectoryPath";
            public const string InGameEditCacheOutputDirectoryPath = "InGameEditCacheOutputDirectoryPath";
            public const string IsPostConvertCommandsEnabled = "IsPostConvertCommandsEnabled";
            public const string IsPreConvertCommandsEnabled = "IsPreConvertCommandsEnabled";
            public const string KeepIntermediateTextSequence = "KeepIntermediateTextSequence";
            public const string OutputLabel = "OutputLabel";
            public const string OutputDirectoryPath = "OutputDirectoryPath";
            public const string PostConvertCommands = "PostConvertCommands";
            public const string PreConvertCommands = "PreConvertCommands";
            public const string SmfTimebase = "SmfTimebase";
            public const string DoUseBuiltInWavePreprocessExe = "DoUseBuiltInWavePreprocessExe";
            public const string WavePreprocessExePath = "WavePreprocessExePath";
        }

        // サウンドアーカイブプレイヤー設定
        public static class SoundArchivePlayer
        {
            public const string SequenceSoundCount = "SoundArchivePlayerSequenceSoundCount";
            public const string SequenceTrackCount = "SoundArchivePlayerSequenceTrackCount";
            public const string StreamSoundCount = "SoundArchivePlayerStreamSoundCount";
            public const string StreamChannelCount = "SoundArchivePlayerStreamChannelCount";
            public const string StreamBufferTimes = "SoundArchivePlayerStreamBufferTimes";
            public const string WaveSoundCount = "SoundArchivePlayerWaveSoundCount";
        }

        // アイテムの命名設定
        public static class ItemNaming
        {
            public const string CaseChange = "CaseChange";
            public const string InvalidCharChange = "InvalidCharChange";
            public const string HasPrefix = "HasPrefix";
            public const string BankNamePrefix = "BankNamePrefix";
            public const string GroupNamePrefix = "GroupNamePrefix";
            public const string InstrumentNamePrefix = "InstrumentNamePrefix";
            public const string PlayerNamePrefix = "PlayerNamePrefix";
            public const string SequenceSoundSetNamePrefix = "SequenceSoundSetNamePrefix";
            public const string SequenceSoundNamePrefix = "SequenceSoundNamePrefix";
            public const string StreamSoundNamePrefix = "StreamSoundNamePrefix";
            public const string WaveSoundSetNamePrefix = "WaveSoundSetNamePrefix";
            public const string WaveSoundNamePrefix = "WaveSoundNamePrefix";
            public const string WaveArchiveNamePrefix = "WaveArchiveNamePrefix";
            public const string ItemPastePostfix = "ItemPastePostfix";
            public const string EnabledNameDelimiter = "EnabledNameDelimiter";
            public const string NameDelimiter = "NameDelimiter";
        }

        // コメントカラム設定
        public static class CommentColumnText
        {
            public const string Comment = "CommentColumnText";
            public const string Comment1 = "Comment1ColumnText";
            public const string Comment2 = "Comment2ColumnText";
            public const string Comment3 = "Comment3ColumnText";
            public const string Comment4 = "Comment4ColumnText";
            public const string Comment5 = "Comment5ColumnText";
            public const string Comment6 = "Comment6ColumnText";
            public const string Comment7 = "Comment7ColumnText";
            public const string Comment8 = "Comment8ColumnText";
            public const string Comment9 = "Comment9ColumnText";
        }

        // カラーコメント設定
        public static class ColorComment
        {
            public const string Comment0 = "ColorComment0";
            public const string Comment1 = "ColorComment1";
            public const string Comment2 = "ColorComment2";
            public const string Comment3 = "ColorComment3";
            public const string Comment4 = "ColorComment4";
            public const string Comment5 = "ColorComment5";
            public const string Comment6 = "ColorComment6";
            public const string Comment7 = "ColorComment7";
            public const string Comment8 = "ColorComment8";
        }

        // ユーザーコマンド設定
        public static class UserCommand
        {
            public const string Command1 = "UserCommand1";
            public const string Command2 = "UserCommand2";
            public const string Command3 = "UserCommand3";
            public const string Command4 = "UserCommand4";
            public const string Command5 = "UserCommand5";
            public const string Command6 = "UserCommand6";
            public const string Command7 = "UserCommand7";
            public const string Command8 = "UserCommand8";

            public const string CommandName1 = "UserCommandName1";
            public const string CommandName2 = "UserCommandName2";
            public const string CommandName3 = "UserCommandName3";
            public const string CommandName4 = "UserCommandName4";
            public const string CommandName5 = "UserCommandName5";
            public const string CommandName6 = "UserCommandName6";
            public const string CommandName7 = "UserCommandName7";
            public const string CommandName8 = "UserCommandName8";
        }

        // ファイルイベント
        public static class FileEvent
        {
            public const string IsFileSavePreCommandEnabled = "IsFileSavePreCommandEnabled";
            public const string IsFileSavePostCommandEnabled = "IsFileSavePostCommandEnabled";
            public const string FileSavePreCommandPath = "FileSavePreCommandPath";
            public const string FileSavePostCommandPath = "FileSavePostCommandPath";
        }

        // sndedit 設定
        public static class SndEditSetting
        {
            public const string SyncPort = "SyncPort";
            public const string FuncPort = "FuncPort";
            public const string CtrlPort = "CtrlPort";

            public const string SyncChannel = "SyncChannel";
            public const string FuncChannel = "FuncChannel";
            public const string CtrlChannel = "CtrlChannel";
        }

        // 接続、切断の設定
        public static class Connection
        {
            public const string EnabledConnectionTimeOut = "EnabledConnectionTimeOut";
            public const string ConnectionTimeOut = "ConnectionTimeOut";
        }

        // 統計
        public static class Statistics
        {
            public const string EnabledIntegratedLoudnessThreshold = "EnabledIntegratedLoudnessThreshold";
            public const string IntegratedLoudnessThreshold = "IntegratedLoudnessThreshold";
            public const string SequenceMaxMeasureDuration = "SequenceMaxMeasureDuration";
        }

        //
        public static class Project
        {
            public const string ProjectComment = "ProjectComment";
        }

        public static class SoundSetItem
        {
            public const string WaveArchiveReference = "WaveArchiveReference";
            public const string PreviewPlay = "PreviewPlay";
            //public const string PreviewMute = "PreviewMute";
            //public const string PreviewSoloPlay = "PreviewSoloPlay";
        }

        public static class Sound
        {
            public const string ActorPlayer = "ActorPlayer";
            public const string ChannelPriority = "ChannelPriority";
            public const string PlayerPriority = "PlayerPriority";
            public const string PlayerReference = "PlayerReference";
            public const string ReleasePriorityFixed = "ReleasePriorityFixed";
            public const string Sends = "Sends";
            public const string Sound3DParams = "Sound3D";
            public const string SinglePlayType = "SinglePlayType";
            public const string SinglePlayEffectiveDuration = "SinglePlayEffectiveDuration";
            public const string UserParameter = "UserParameter";
            public const string UserParameter1 = "UserParameter1";
            public const string UserParameter2 = "UserParameter2";
            public const string UserParameter3 = "UserParameter3";
        }

        public static class StreamSound
        {
            public const string IsPrefetchEnabled = "IsPrefetchEnabled";
        }

        public static class StreamSoundTrack
        {
            public const string TrackNo = "TrackNo";
            public const string TrackVolume = "TrackVolume";

            public const string ChannelCount = "ChannelCount";

            public const string PreviewMute = "PreviewMute";
            public const string PreviewSoloPlay = "PreviewSoloPlay";

            public static class Sends
            {
                public const string MainSend = "TrackSends" + Sep + nameof(ProjectParameterNames.Sends.MainSend);
                public const string AuxASend = "TrackSends" + Sep + nameof(ProjectParameterNames.Sends.AuxASend);
                public const string AuxBSend = "TrackSends" + Sep + nameof(ProjectParameterNames.Sends.AuxBSend);
            }
        }

        public static class WaveSound
        {
            public const string EnvelopeRelease = "EnvelopeRelease";
        }

        public static class SequenceSound
        {
            public const string FileType = "SequenceSoundFileType";
            public const string SoundSetBankReference = "SoundSetBankReference";
            public const string SoundSetBankReferences = "SoundSetBankReferences";

            public const string SoundSetBankReference0 = "SoundSetBankReference0";
            public const string SoundSetBankReference1 = "SoundSetBankReference1";
            public const string SoundSetBankReference2 = "SoundSetBankReference2";
            public const string SoundSetBankReference3 = "SoundSetBankReference3";

            public const string StartPosition = "StartPosition";
        }

        public static class Player
        {
            public const string HeapSize = "PlayerHeapSize";
            public const string SoundLimit = "PlayerSoundLimit";
        }

        public static class WaveArchive
        {
            public const string LoadType = "WaveArchiveLoadType";
        }

        public static class Group
        {
            public const string OutputType = "GroupOutputType";
        }

        public static class GroupItem
        {
            public const string RegisterType = "GroupItemRegisterType";
            public const string GroupItemTargetSoundSet = "GroupItemTargetSoundSet";
        }

        public static class Instrument
        {
            public const string ProgramNo = "ProgramNo";
            public const string EnvelopeMode = "InstrumentEnvelopeMode";
        }

        public static class KeyRegion
        {
            public const string KeyMax = "KeyMax";
            public const string KeyMin = "KeyMin";
        }

        public static class VelocityRegion
        {
            public const string KeyGroup = "KeyGroup";
            public const string OriginalKey = "OriginalKey";
            public const string PercussionMode = "PercussionMode";
            public const string PitchCents = "PitchCents";
            public const string PitchSemitones = "PitchSemitones";
            public const string VelocityMax = "VelocityMax";
            public const string VelocityMin = "VelocityMin";
            public const string InterpolationType = "InterpolationType";
        }

        public static class Envelope
        {
            public const string Attack = nameof(Envelope) + Sep + nameof(Attack);
            public const string Decay = nameof(Envelope) + Sep + nameof(Decay);
            public const string Hold = nameof(Envelope) + Sep + nameof(Hold);
            public const string Sustain = nameof(Envelope) + Sep + nameof(Sustain);
            public const string Release = nameof(Envelope) + Sep + nameof(Release);
        }

        public static class Sends
        {
            public const string MainSend = nameof(Sends) + Sep + nameof(MainSend);
            public const string AuxASend = nameof(Sends) + Sep + nameof(AuxASend);
            public const string AuxBSend = nameof(Sends) + Sep + nameof(AuxBSend);
        }

        public static class Sound3D
        {
            public const string DecayCurve3D = nameof(Sound3D) + Sep + nameof(DecayCurve3D);
            public const string DecayRatio3D = nameof(Sound3D) + Sep + nameof(DecayRatio3D);
            public const string DopplerFactor3D = nameof(Sound3D) + Sep + nameof(DopplerFactor3D);
            public const string Enable3DFilter = nameof(Sound3D) + Sep + nameof(Enable3DFilter);
            public const string Enable3DPan = nameof(Sound3D) + Sep + nameof(Enable3DPan);
            public const string Enable3DPriority = nameof(Sound3D) + Sep + nameof(Enable3DPriority);
            public const string Enable3DSurroundPan = nameof(Sound3D) + Sep + nameof(Enable3DSurroundPan);
            public const string Enable3DVolume = nameof(Sound3D) + Sep + nameof(Enable3DVolume);
        }
    }
}
