﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using Core;
    using Core.Parameters;
    using Resources;
    using ToolDevelopmentKit;

    /// <summary>
    /// BiquadType 型のパラメータ値を格納します。
    /// </summary>
    public class BiquadTypeParameterValue : ParameterValue<BiquadType>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public BiquadTypeParameterValue()
            : this(BiquadType.None)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータ値を指定します。</param>
        public BiquadTypeParameterValue(BiquadType value)
            : base(value)
        {
        }

        /// <summary>
        /// パラメータの値を取得するキャストオペレータです。
        /// </summary>
        /// <param name="value">対象となるパラメータ値を指定します。</param>
        /// <returns>パラメータの値を返します。</returns>
        public static implicit operator BiquadType(BiquadTypeParameterValue value)
        {
            Ensure.Argument.NotNull(value);
            return value.Value;
        }

        /// <summary>
        /// パラメータの値からテキストを取得します。
        /// </summary>
        /// <returns>テキストを返します。</returns>
        public override string ToString()
        {
            switch (this.Value)
            {
                case BiquadType.None: return MessageResource.Label_BiquadType_None;
                case BiquadType.LPF: return MessageResource.Label_BiquadType_LPF;
                case BiquadType.HPF: return MessageResource.Label_BiquadType_HPF;
                case BiquadType.BPF512: return MessageResource.Label_BiquadType_BPF512;
                case BiquadType.BPF1024: return MessageResource.Label_BiquadType_BPF1024;
                case BiquadType.BPF2048: return MessageResource.Label_BiquadType_BPF2048;
                case BiquadType.USR0: return MessageResource.Label_BiquadType_USR0;
                case BiquadType.USR1: return MessageResource.Label_BiquadType_USR1;
                case BiquadType.USR2: return MessageResource.Label_BiquadType_USR2;
                case BiquadType.USR3: return MessageResource.Label_BiquadType_USR3;
                case BiquadType.USR4: return MessageResource.Label_BiquadType_USR4;
                case BiquadType.USR5: return MessageResource.Label_BiquadType_USR5;
                case BiquadType.USR6: return MessageResource.Label_BiquadType_USR6;
                case BiquadType.USR7: return MessageResource.Label_BiquadType_USR7;
                case BiquadType.USR8: return MessageResource.Label_BiquadType_USR8;
                case BiquadType.USR9: return MessageResource.Label_BiquadType_USR9;
                case BiquadType.USR10: return MessageResource.Label_BiquadType_USR10;
                case BiquadType.USR11: return MessageResource.Label_BiquadType_USR11;
                case BiquadType.USR12: return MessageResource.Label_BiquadType_USR12;
                case BiquadType.USR13: return MessageResource.Label_BiquadType_USR13;
                case BiquadType.USR14: return MessageResource.Label_BiquadType_USR14;
                case BiquadType.USR15: return MessageResource.Label_BiquadType_USR15;
                case BiquadType.USR16: return MessageResource.Label_BiquadType_USR16;
                case BiquadType.USR17: return MessageResource.Label_BiquadType_USR17;
                case BiquadType.USR18: return MessageResource.Label_BiquadType_USR18;
                case BiquadType.USR19: return MessageResource.Label_BiquadType_USR19;
                case BiquadType.USR20: return MessageResource.Label_BiquadType_USR20;
                case BiquadType.USR21: return MessageResource.Label_BiquadType_USR21;
                case BiquadType.USR22: return MessageResource.Label_BiquadType_USR22;
                case BiquadType.USR23: return MessageResource.Label_BiquadType_USR23;
                case BiquadType.USR24: return MessageResource.Label_BiquadType_USR24;
                case BiquadType.USR25: return MessageResource.Label_BiquadType_USR25;
                case BiquadType.USR26: return MessageResource.Label_BiquadType_USR26;
                case BiquadType.USR27: return MessageResource.Label_BiquadType_USR27;
                case BiquadType.USR28: return MessageResource.Label_BiquadType_USR28;
                case BiquadType.USR29: return MessageResource.Label_BiquadType_USR29;
                case BiquadType.USR30: return MessageResource.Label_BiquadType_USR30;
                case BiquadType.USR31: return MessageResource.Label_BiquadType_USR31;
                case BiquadType.USR32: return MessageResource.Label_BiquadType_USR32;
                case BiquadType.USR33: return MessageResource.Label_BiquadType_USR33;
                case BiquadType.USR34: return MessageResource.Label_BiquadType_USR34;
                case BiquadType.USR35: return MessageResource.Label_BiquadType_USR35;
                case BiquadType.USR36: return MessageResource.Label_BiquadType_USR36;
                case BiquadType.USR37: return MessageResource.Label_BiquadType_USR37;
                case BiquadType.USR38: return MessageResource.Label_BiquadType_USR38;
                case BiquadType.USR39: return MessageResource.Label_BiquadType_USR39;
                case BiquadType.USR40: return MessageResource.Label_BiquadType_USR40;
                case BiquadType.USR41: return MessageResource.Label_BiquadType_USR41;
                case BiquadType.USR42: return MessageResource.Label_BiquadType_USR42;
                case BiquadType.USR43: return MessageResource.Label_BiquadType_USR43;
                case BiquadType.USR44: return MessageResource.Label_BiquadType_USR44;
                case BiquadType.USR45: return MessageResource.Label_BiquadType_USR45;
                case BiquadType.USR46: return MessageResource.Label_BiquadType_USR46;
                case BiquadType.USR47: return MessageResource.Label_BiquadType_USR47;
                case BiquadType.USR48: return MessageResource.Label_BiquadType_USR48;
                case BiquadType.USR49: return MessageResource.Label_BiquadType_USR49;
                case BiquadType.USR50: return MessageResource.Label_BiquadType_USR50;
                case BiquadType.USR51: return MessageResource.Label_BiquadType_USR51;
                case BiquadType.USR52: return MessageResource.Label_BiquadType_USR52;
                case BiquadType.USR53: return MessageResource.Label_BiquadType_USR53;
                case BiquadType.USR54: return MessageResource.Label_BiquadType_USR54;
                case BiquadType.USR55: return MessageResource.Label_BiquadType_USR55;
                case BiquadType.USR56: return MessageResource.Label_BiquadType_USR56;
                case BiquadType.USR57: return MessageResource.Label_BiquadType_USR57;
                case BiquadType.USR58: return MessageResource.Label_BiquadType_USR58;
                case BiquadType.USR59: return MessageResource.Label_BiquadType_USR59;
                case BiquadType.USR60: return MessageResource.Label_BiquadType_USR60;
                case BiquadType.USR61: return MessageResource.Label_BiquadType_USR61;
                case BiquadType.USR62: return MessageResource.Label_BiquadType_USR62;
                case BiquadType.USR63: return MessageResource.Label_BiquadType_USR63;
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        /// <summary>
        /// テキストからパラメータ値を取得します。
        /// </summary>
        /// <param name="text">テキストを指定します。</param>
        protected override BiquadType ParseInternal(string text)
        {
            Ensure.Argument.NotNull(text);

            if (text == MessageResource.Label_BiquadType_None) return BiquadType.None;
            if (text == MessageResource.Label_BiquadType_LPF) return BiquadType.LPF;
            if (text == MessageResource.Label_BiquadType_HPF) return BiquadType.HPF;
            if (text == MessageResource.Label_BiquadType_BPF512) return BiquadType.BPF512;
            if (text == MessageResource.Label_BiquadType_BPF1024) return BiquadType.BPF1024;
            if (text == MessageResource.Label_BiquadType_BPF2048) return BiquadType.BPF2048;
            if (text == MessageResource.Label_BiquadType_USR0) return BiquadType.USR0;
            if (text == MessageResource.Label_BiquadType_USR1) return BiquadType.USR1;
            if (text == MessageResource.Label_BiquadType_USR2) return BiquadType.USR2;
            if (text == MessageResource.Label_BiquadType_USR3) return BiquadType.USR3;
            if (text == MessageResource.Label_BiquadType_USR4) return BiquadType.USR4;
            if (text == MessageResource.Label_BiquadType_USR5) return BiquadType.USR5;
            if (text == MessageResource.Label_BiquadType_USR6) return BiquadType.USR6;
            if (text == MessageResource.Label_BiquadType_USR7) return BiquadType.USR7;
            if (text == MessageResource.Label_BiquadType_USR8) return BiquadType.USR8;
            if (text == MessageResource.Label_BiquadType_USR9) return BiquadType.USR9;
            if (text == MessageResource.Label_BiquadType_USR10) return BiquadType.USR10;
            if (text == MessageResource.Label_BiquadType_USR11) return BiquadType.USR11;
            if (text == MessageResource.Label_BiquadType_USR12) return BiquadType.USR12;
            if (text == MessageResource.Label_BiquadType_USR13) return BiquadType.USR13;
            if (text == MessageResource.Label_BiquadType_USR14) return BiquadType.USR14;
            if (text == MessageResource.Label_BiquadType_USR15) return BiquadType.USR15;
            if (text == MessageResource.Label_BiquadType_USR16) return BiquadType.USR16;
            if (text == MessageResource.Label_BiquadType_USR17) return BiquadType.USR17;
            if (text == MessageResource.Label_BiquadType_USR18) return BiquadType.USR18;
            if (text == MessageResource.Label_BiquadType_USR19) return BiquadType.USR19;
            if (text == MessageResource.Label_BiquadType_USR20) return BiquadType.USR20;
            if (text == MessageResource.Label_BiquadType_USR21) return BiquadType.USR21;
            if (text == MessageResource.Label_BiquadType_USR22) return BiquadType.USR22;
            if (text == MessageResource.Label_BiquadType_USR23) return BiquadType.USR23;
            if (text == MessageResource.Label_BiquadType_USR24) return BiquadType.USR24;
            if (text == MessageResource.Label_BiquadType_USR25) return BiquadType.USR25;
            if (text == MessageResource.Label_BiquadType_USR26) return BiquadType.USR26;
            if (text == MessageResource.Label_BiquadType_USR27) return BiquadType.USR27;
            if (text == MessageResource.Label_BiquadType_USR28) return BiquadType.USR28;
            if (text == MessageResource.Label_BiquadType_USR29) return BiquadType.USR29;
            if (text == MessageResource.Label_BiquadType_USR30) return BiquadType.USR30;
            if (text == MessageResource.Label_BiquadType_USR31) return BiquadType.USR31;
            if (text == MessageResource.Label_BiquadType_USR32) return BiquadType.USR32;
            if (text == MessageResource.Label_BiquadType_USR33) return BiquadType.USR33;
            if (text == MessageResource.Label_BiquadType_USR34) return BiquadType.USR34;
            if (text == MessageResource.Label_BiquadType_USR35) return BiquadType.USR35;
            if (text == MessageResource.Label_BiquadType_USR36) return BiquadType.USR36;
            if (text == MessageResource.Label_BiquadType_USR37) return BiquadType.USR37;
            if (text == MessageResource.Label_BiquadType_USR38) return BiquadType.USR38;
            if (text == MessageResource.Label_BiquadType_USR39) return BiquadType.USR39;
            if (text == MessageResource.Label_BiquadType_USR40) return BiquadType.USR40;
            if (text == MessageResource.Label_BiquadType_USR41) return BiquadType.USR41;
            if (text == MessageResource.Label_BiquadType_USR42) return BiquadType.USR42;
            if (text == MessageResource.Label_BiquadType_USR43) return BiquadType.USR43;
            if (text == MessageResource.Label_BiquadType_USR44) return BiquadType.USR44;
            if (text == MessageResource.Label_BiquadType_USR45) return BiquadType.USR45;
            if (text == MessageResource.Label_BiquadType_USR46) return BiquadType.USR46;
            if (text == MessageResource.Label_BiquadType_USR47) return BiquadType.USR47;
            if (text == MessageResource.Label_BiquadType_USR48) return BiquadType.USR48;
            if (text == MessageResource.Label_BiquadType_USR49) return BiquadType.USR49;
            if (text == MessageResource.Label_BiquadType_USR50) return BiquadType.USR50;
            if (text == MessageResource.Label_BiquadType_USR51) return BiquadType.USR51;
            if (text == MessageResource.Label_BiquadType_USR52) return BiquadType.USR52;
            if (text == MessageResource.Label_BiquadType_USR53) return BiquadType.USR53;
            if (text == MessageResource.Label_BiquadType_USR54) return BiquadType.USR54;
            if (text == MessageResource.Label_BiquadType_USR55) return BiquadType.USR55;
            if (text == MessageResource.Label_BiquadType_USR56) return BiquadType.USR56;
            if (text == MessageResource.Label_BiquadType_USR57) return BiquadType.USR57;
            if (text == MessageResource.Label_BiquadType_USR58) return BiquadType.USR58;
            if (text == MessageResource.Label_BiquadType_USR59) return BiquadType.USR59;
            if (text == MessageResource.Label_BiquadType_USR60) return BiquadType.USR60;
            if (text == MessageResource.Label_BiquadType_USR61) return BiquadType.USR61;
            if (text == MessageResource.Label_BiquadType_USR62) return BiquadType.USR62;
            if (text == MessageResource.Label_BiquadType_USR63) return BiquadType.USR63;

            throw new ArgumentException("invalid text.");
        }

        /// <summary>
        /// 指定した値を検証します。
        /// </summary>
        /// <param name="value">検証する値を指定します。</param>
        /// <returns>検証結果を返します。</returns>
        protected override ValidationResult ValidateInternal(BiquadType value)
        {
            return ValidationResult.NoError;
        }

        /// <summary>
        /// パラメータ値のバイト列を取得します。
        /// </summary>
        /// <returns>バイト列の列挙子を返します。</returns>
        protected override IEnumerable<byte> GetBytes()
        {
            return BitConverter.GetBytes((int)this.Value);
        }
    }
}
