﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    public enum UserParameterShowColumnType
    {
        Defined = 0,
        Binary,
        Hexadecimal,
    }

    public class UserParameterStructureSetting : ICloneable
    {
        private List<UserParameterStructure> structures = new List<UserParameterStructure>();

        public bool Enabled
        {
            get;
            set;
        }

        public UserParameterShowColumnType ShowColumnType
        {
            get;
            set;
        }

        public List<UserParameterStructure> Structures
        {
            get
            {
                return this.structures;
            }
        }

        public object Clone()
        {
            UserParameterStructureSetting setting = new UserParameterStructureSetting();
            setting.Enabled = this.Enabled;
            setting.ShowColumnType = this.ShowColumnType;

            foreach (UserParameterStructure structure in this.Structures)
            {
                setting.Structures.Add((UserParameterStructure)structure.Clone());
            }

            return setting;
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            if (!(obj is UserParameterStructureSetting))
            {
                return false;
            }

            UserParameterStructureSetting setting = obj as UserParameterStructureSetting;

            if (this.Enabled != setting.Enabled)
            {
                return false;
            }

            if (this.ShowColumnType != setting.ShowColumnType)
            {
                return false;
            }

            if (this.Structures.Count != setting.Structures.Count)
            {
                return false;
            }

            for (int index = 0; index < this.Structures.Count; index++)
            {
                if (this.Structures[index].Equals(setting.Structures[index]) == false)
                {
                    return false;
                }
            }

            return true;
        }

        public void CopyFrom(UserParameterStructureSetting setting)
        {
            this.Enabled = setting.Enabled;
            this.ShowColumnType = setting.ShowColumnType;

            this.Structures.Clear();

            foreach (UserParameterStructure structure in setting.Structures)
            {
                UserParameterStructure duplicatedStructure = structure.Clone() as UserParameterStructure;
                this.Structures.Add(duplicatedStructure);
            }
        }
    }
}
