﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class LoopTypeEx
    {
        public static string ToText(this LoopType value)
        {
            switch (value)
            {
                case LoopType.InFile:
                    return "InFile";

                case LoopType.Manual:
                    return "Manual";

                case LoopType.None:
                    return "None";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static LoopType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "InFile":
                    return LoopType.InFile;

                case "Manual":
                    return LoopType.Manual;

                case "None":
                    return LoopType.None;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
