﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class BiquadTypeEx
    {
        public static string ToText(this BiquadType value)
        {
            switch (value)
            {
                case BiquadType.None: return "None";
                case BiquadType.INHERIT: return "INHERIT";
                case BiquadType.LPF: return "LPF";
                case BiquadType.HPF: return "HPF";
                case BiquadType.BPF512: return "BPF512";
                case BiquadType.BPF1024: return "BPF1024";
                case BiquadType.BPF2048: return "BPF2048";
                case BiquadType.USR0: return "USR0";
                case BiquadType.USR1: return "USR1";
                case BiquadType.USR2: return "USR2";
                case BiquadType.USR3: return "USR3";
                case BiquadType.USR4: return "USR4";
                case BiquadType.USR5: return "USR5";
                case BiquadType.USR6: return "USR6";
                case BiquadType.USR7: return "USR7";
                case BiquadType.USR8: return "USR8";
                case BiquadType.USR9: return "USR9";
                case BiquadType.USR10: return "USR10";
                case BiquadType.USR11: return "USR11";
                case BiquadType.USR12: return "USR12";
                case BiquadType.USR13: return "USR13";
                case BiquadType.USR14: return "USR14";
                case BiquadType.USR15: return "USR15";
                case BiquadType.USR16: return "USR16";
                case BiquadType.USR17: return "USR17";
                case BiquadType.USR18: return "USR18";
                case BiquadType.USR19: return "USR19";
                case BiquadType.USR20: return "USR20";
                case BiquadType.USR21: return "USR21";
                case BiquadType.USR22: return "USR22";
                case BiquadType.USR23: return "USR23";
                case BiquadType.USR24: return "USR24";
                case BiquadType.USR25: return "USR25";
                case BiquadType.USR26: return "USR26";
                case BiquadType.USR27: return "USR27";
                case BiquadType.USR28: return "USR28";
                case BiquadType.USR29: return "USR29";
                case BiquadType.USR30: return "USR30";
                case BiquadType.USR31: return "USR31";
                case BiquadType.USR32: return "USR32";
                case BiquadType.USR33: return "USR33";
                case BiquadType.USR34: return "USR34";
                case BiquadType.USR35: return "USR35";
                case BiquadType.USR36: return "USR36";
                case BiquadType.USR37: return "USR37";
                case BiquadType.USR38: return "USR38";
                case BiquadType.USR39: return "USR39";
                case BiquadType.USR40: return "USR40";
                case BiquadType.USR41: return "USR41";
                case BiquadType.USR42: return "USR42";
                case BiquadType.USR43: return "USR43";
                case BiquadType.USR44: return "USR44";
                case BiquadType.USR45: return "USR45";
                case BiquadType.USR46: return "USR46";
                case BiquadType.USR47: return "USR47";
                case BiquadType.USR48: return "USR48";
                case BiquadType.USR49: return "USR49";
                case BiquadType.USR50: return "USR50";
                case BiquadType.USR51: return "USR51";
                case BiquadType.USR52: return "USR52";
                case BiquadType.USR53: return "USR53";
                case BiquadType.USR54: return "USR54";
                case BiquadType.USR55: return "USR55";
                case BiquadType.USR56: return "USR56";
                case BiquadType.USR57: return "USR57";
                case BiquadType.USR58: return "USR58";
                case BiquadType.USR59: return "USR59";
                case BiquadType.USR60: return "USR60";
                case BiquadType.USR61: return "USR61";
                case BiquadType.USR62: return "USR62";
                case BiquadType.USR63: return "USR63";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static BiquadType Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "None": return BiquadType.None;
                case "INHERIT": return BiquadType.INHERIT;
                case "LPF": return BiquadType.LPF;
                case "HPF": return BiquadType.HPF;
                case "BPF512": return BiquadType.BPF512;
                case "BPF1024": return BiquadType.BPF1024;
                case "BPF2048": return BiquadType.BPF2048;
                case "USR0": return BiquadType.USR0;
                case "USR1": return BiquadType.USR1;
                case "USR2": return BiquadType.USR2;
                case "USR3": return BiquadType.USR3;
                case "USR4": return BiquadType.USR4;
                case "USR5": return BiquadType.USR5;
                case "USR6": return BiquadType.USR6;
                case "USR7": return BiquadType.USR7;
                case "USR8": return BiquadType.USR8;
                case "USR9": return BiquadType.USR9;
                case "USR10": return BiquadType.USR10;
                case "USR11": return BiquadType.USR11;
                case "USR12": return BiquadType.USR12;
                case "USR13": return BiquadType.USR13;
                case "USR14": return BiquadType.USR14;
                case "USR15": return BiquadType.USR15;
                case "USR16": return BiquadType.USR16;
                case "USR17": return BiquadType.USR17;
                case "USR18": return BiquadType.USR18;
                case "USR19": return BiquadType.USR19;
                case "USR20": return BiquadType.USR20;
                case "USR21": return BiquadType.USR21;
                case "USR22": return BiquadType.USR22;
                case "USR23": return BiquadType.USR23;
                case "USR24": return BiquadType.USR24;
                case "USR25": return BiquadType.USR25;
                case "USR26": return BiquadType.USR26;
                case "USR27": return BiquadType.USR27;
                case "USR28": return BiquadType.USR28;
                case "USR29": return BiquadType.USR29;
                case "USR30": return BiquadType.USR30;
                case "USR31": return BiquadType.USR31;
                case "USR32": return BiquadType.USR32;
                case "USR33": return BiquadType.USR33;
                case "USR34": return BiquadType.USR34;
                case "USR35": return BiquadType.USR35;
                case "USR36": return BiquadType.USR36;
                case "USR37": return BiquadType.USR37;
                case "USR38": return BiquadType.USR38;
                case "USR39": return BiquadType.USR39;
                case "USR40": return BiquadType.USR40;
                case "USR41": return BiquadType.USR41;
                case "USR42": return BiquadType.USR42;
                case "USR43": return BiquadType.USR43;
                case "USR44": return BiquadType.USR44;
                case "USR45": return BiquadType.USR45;
                case "USR46": return BiquadType.USR46;
                case "USR47": return BiquadType.USR47;
                case "USR48": return BiquadType.USR48;
                case "USR49": return BiquadType.USR49;
                case "USR50": return BiquadType.USR50;
                case "USR51": return BiquadType.USR51;
                case "USR52": return BiquadType.USR52;
                case "USR53": return BiquadType.USR53;
                case "USR54": return BiquadType.USR54;
                case "USR55": return BiquadType.USR55;
                case "USR56": return BiquadType.USR56;
                case "USR57": return BiquadType.USR57;
                case "USR58": return BiquadType.USR58;
                case "USR59": return BiquadType.USR59;
                case "USR60": return BiquadType.USR60;
                case "USR61": return BiquadType.USR61;
                case "USR62": return BiquadType.USR62;
                case "USR63": return BiquadType.USR63;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
