﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System.IO;
    using System.Text;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.ToolDevelopmentKit;

    public class TextSequenceSoundDocumentWriter : IDocumentWriter
    {
        private readonly string documentTypeName = string.Empty;

        public TextSequenceSoundDocumentWriter(string documentTypeName)
        {
            Ensure.Argument.StringNotEmpty(documentTypeName);
            this.documentTypeName = documentTypeName;
        }

        /// <summary>
        /// 対応するドキュメントの種類を取得します。
        /// </summary>
        public string DocumentTypeName
        {
            get { return this.documentTypeName; }
        }

        public void Write(IStreamResource resource, Document document, Document[] documents)
        {
            Ensure.Argument.NotNull(resource);
            Ensure.Argument.True(resource is FileResource);
            Ensure.Argument.True(document is TextSequenceSoundDocument);

            TextSequenceSoundDocument textSequenceSoundDocument = document as TextSequenceSoundDocument;
            File.WriteAllText(document.Resource.Key, textSequenceSoundDocument.Text, Encoding.Default);
        }
    }
}
