﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Documents;
    using ToolDevelopmentKit;

    /// <summary>
    /// サウンドセットドキュメントを生成します。
    /// </summary>
    public class SoundSetDocumentFactory : IDocumentFactory
    {
        private string documentTypeName = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="documentTypeName">ドキュメントのタイプ名を指定します。</param>
        public SoundSetDocumentFactory(string documentTypeName = Platforms.Any.SoundSetDocument)
        {
            Ensure.Argument.NotNull(documentTypeName);
            this.documentTypeName = documentTypeName;
        }

        /// <summary>
        /// 生成するドキュメントのタイプ名を取得します。
        /// </summary>
        public string TypeName
        {
            get { return this.documentTypeName; }
        }

        /// <summary>
        /// ドキュメントを生成します。
        /// </summary>
        /// <returns>生成されたドキュメント。</returns>
        public virtual Document CreateDocument()
        {
            return new SoundSetDocument(TypeName);
        }
    }
}
