﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;

    public class SoundSetDocument : SoundDocument
    {
        private string documentTypeName = string.Empty;

        private ComponentDictionaryImpl components = null;
        private SoundSet soundSet = null;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundSetDocument(string documentTypeName)
        {
            if (null == documentTypeName) { throw new ArgumentNullException("documentTypeName"); }
            if (0 == documentTypeName.Length) { throw new ArgumentException("documentTypeName.Length must not be 0."); }

            this.documentTypeName = documentTypeName;
            this.components = new ComponentDictionaryImpl();
        }

        /// <summary>
        /// サウンドセットが変更されると発生します。
        /// </summary>
        public event EventHandler SoundSetChanged;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundSet SoundSet
        {
            get { return this.soundSet; }
            set
            {
                if (value == this.soundSet) { return; }

                if (null != this.soundSet)
                {
                    this.components.Remove(this.soundSet);
                }

                this.soundSet = value;

                if (null != this.soundSet)
                {
                    this.components.Add(this.soundSet.Name, this.soundSet);
                }

                OnSoundSetChanged(EventArgs.Empty);
            }
        }

        /// <summary>
        /// ドキュメントの最上位コンポーネントの一覧を取得します。
        /// </summary>
        public override Component[] TopComponents
        {
            get { return new Component[] { SoundSet }; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string TypeName
        {
            get { return this.documentTypeName; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override object Clone()
        {
            //未実装
            throw new NotImplementedException();
        }

        protected virtual void OnSoundSetChanged(EventArgs e)
        {
            if (null != SoundSetChanged)
            {
                SoundSetChanged(this, e);
            }
        }
    }
}
