﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    public class WaveArchiveBase : SoundSetItem
    {
        /// <summary>
        /// ロードタイプを取得または設定します。
        /// </summary>
        public WaveArchiveLoadType LoadType
        {
            get { return GetValue<WaveArchiveLoadType>(ProjectParameterNames.WaveArchive.LoadType); }
            set { SetValue<WaveArchiveLoadType>(ProjectParameterNames.WaveArchive.LoadType, value); }
        }

        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            this.Parameters.AddValue(
               ProjectParameterNames.WaveArchive.LoadType, new WaveArchiveLoadTypeParameterValue());
        }
    }
}
