﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System.Linq;
    using NintendoWare.ToolDevelopmentKit;

    public static class StreamSoundExtension
    {
        /// <summary>
        /// 指定ストリームサウンドがマルチトラックかどうか調べます。
        /// </summary>
        /// <param name="target">ストリームサウンドを指定します。</param>
        /// <returns>マルチトラックの場合は true、それ以外の場合は false を返します。</returns>
        public static bool HasMultiTracks(this StreamSoundBase target)
        {
            Ensure.Argument.NotNull(target);

            // 有効トラックが２つ以上あるかどうかを調べます。
            return target.Children.
                OfType<StreamSoundTrackBase>().
                Where(track => track.IsEnabled).
                Skip(1).
                Any();
        }
    }
}
