﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.ToolDevelopmentKit.Collections;
    using System;
    using System.Collections.Generic;
    using System.Collections.Specialized;

    public class SoundSet : Component
    {
        private IDictionary<string, object> itemResources = new ObservableDictionary<string, object>();

        public SoundSet()
        {
            ((INotifyCollectionChanged)this.itemResources).CollectionChanged += (sender, e) =>
            {
                if (this.ItemResourcesChanged != null)
                {
                    this.ItemResourcesChanged(this, EventArgs.Empty);
                }
            };
        }

        public event EventHandler ItemResourcesChanged;

        public bool HideEmptyNode { get; set; }

        public IDictionary<string, object> ItemResources
        {
            get { return this.itemResources; }
        }
    }
}
