﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NintendoWare.SoundFoundation.Projects
{
    // サウンドセットの読み込みに必要な情報を保持するクラスです。
    // プロジェクトの読み込み時にプロジェクトツリーに一時的に追加され、
    // サウンドセットファイルが読み込まれると、生成された SoundSet と置き換えられます。
    // 最終的にプロジェクトツリーの全ての ProjectSoundSetComponent は SoundSet に置き換わります。
    // SoundSet に置き換えられた後は、サウンドセットのファイルパスの情報として SoundProject で保持されます。

    public class ProjectSoundSetComponent : Component
    {
        public ProjectSoundSetComponent(string name, string targetFilePath)
        {
            this.Name = name;
            this.TargetFilePath = targetFilePath;
        }

        public string TargetFilePath { get; }
    }
}
