﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;

    public struct ItemID
    {
        public static readonly ItemID InvalidValue = new ItemID(UInt32.MaxValue);

        private UInt32 value;

        public ItemID(UInt32 value)
        {
            this.value = value;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 Value
        {
            get { return this.value; }
            set { this.value = value; }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        public static implicit operator ItemID(UInt32 value)
        {
            return new ItemID(value);
        }

        public static implicit operator UInt32(ItemID value)
        {
            return value.Value;
        }

        //-----------------------------------------------------------------

        public override string ToString()
        {
            return this.value.ToString();
        }
    }
}
