﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;

    /// <summary>
    /// バンクアイテムを表します。
    /// </summary>
    public class BankItem : Component
    {
        ///--------------------------------
        /// <summary>
        /// 所属するバンクを取得します。
        /// </summary>
        public Bank Bank
        {
            get
            {
                Component parent = Parent;

                while (null != parent)
                {
                    if (parent is Bank) { return parent as Bank; }
                    parent = parent.Parent;
                }

                return null;
            }
        }

        ///--------------------------------
        /// <summary>
        /// 所属するインストルメントを取得します。
        /// </summary>
        public Instrument Instrument
        {
            get
            {
                Component current = this;

                while (null != current)
                {
                    if (current is Instrument) { return current as Instrument; }
                    current = current.Parent;
                }

                return null;
            }
        }
    }
}
