﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Logs
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using ToolDevelopmentKit;

    /// <summary>
    /// ライン出力イベントのパラメータを格納します。
    /// </summary>
    public class OutputLineEventArgs : EventArgs
    {
        private OutputLine[] lines;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="line">ラインを指定します。</param>
        public OutputLineEventArgs(OutputLine line)
        {
            this.lines = new OutputLine[] { line };
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="lines">ラインの列挙子を指定します。</param>
        public OutputLineEventArgs(IEnumerable<OutputLine> lines)
        {
            Ensure.Argument.NotNull(lines);
            this.lines = lines.ToArray();
        }

        /// <summary>
        /// ラインの配列を取得します。
        /// </summary>
        public OutputLine[] Lines
        {
            get { return this.lines; }
        }
    }
}
