﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Logs
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    public class OutputLine
    {
        private OutputLevel level = OutputLevel.Error;
        private string text = string.Empty;
        private Component[] components = new Component[0];

        public OutputLine(OutputLevel level, string text)
        {
            Initialize(level, text, null);
        }

        public OutputLine(OutputLevel level, string text, Component component)
        {
            Initialize(level, text,
                (component == null) ? null : new Component[] { component });
        }

        public OutputLine(OutputLevel level, string text, params Component[] components)
        {
            Initialize(level, text, components);
        }

        public OutputLevel Level
        {
            get { return this.level; }
        }

        public string Text
        {
            get { return Header + this.text; }
        }

        public Component[] Components
        {
            get
            {
                return this.components;
            }

            set
            {
                Ensure.Argument.NotNull(value);
                this.components = value;
            }
        }

        protected virtual string Header
        {
            get { return string.Empty; }
        }

        public override string ToString()
        {
            return this.Text;
        }

        protected string GetTargetComponentName()
        {
            foreach (Component component in this.components)
            {
                Component target = component;

                while (target != null)
                {
                    if (target.Name.Length > 0)
                    {
                        return target.Name;
                    }

                    target = target.Parent;
                }
            }

            return string.Empty;
        }

        private void Initialize(OutputLevel level, string text, Component[] components)
        {
            this.level = level;

            if (text != null)
            {
                this.text = text;
            }

            if (components != null)
            {
                this.components = components;
            }
        }
    }
}
