﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.FileFormats.Wave
{
    using NintendoWare.SoundFoundation.FileFormats.Audio;
    using NintendoWare.SoundFoundation.Resources;

    public class WaveFileAACReader : WaveFileReader
    {
        private Stream strm;
        private string filePath;

        public override void Close()
        {
            strm.Close();
            filePath = null;
        }

        // ダミーです、実際には使用しません。
        public override byte[] Read()
        {
            Debug.Assert(false);
            return null;
        }

        protected override void DisposeInternal()
        {
            if (strm != null)
            {
                strm.Close();
            }
            filePath = null;
        }

        // ダミーです、実際には使用しません。
        protected override WaveDataStream CreateDataStream()
        {
            Debug.Assert(false);
            return null;
        }

        protected override WaveFile OpenInternal(string filePath)
        {
            try
            {
                return OpenAAC(filePath);
            }
            catch (Exception e)
            {
                if (e is WaveFileReaderException)
                {
                    throw e;
                }
                else
                {
                    this.filePath = null;

                    string message =
                        MessageResource.Message_InvalidWaveFile + " \"" + filePath + "\"";

                    throw new WaveFileReaderException(message);
                }
            }
        }

        private WaveFileAAC OpenAAC(string filePath)
        {
            WaveFileAAC waveFile = new WaveFileAAC();

            strm = File.OpenRead(filePath);

            AdtsHeader adtsHeader = AdtsHeader.Parse(strm);
            if (adtsHeader != null && adtsHeader.IsValid() == true)
            {
                waveFile.SampleRate = adtsHeader.SamplesPerSec;
                waveFile.ChannelCount = adtsHeader.Channel;
            }

            this.filePath = filePath;

            return waveFile;
        }
    }
}
