﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;
    using ToolDevelopmentKit;

    public abstract class XmlSimpleParameter<TValue> : XmlParameter
    {
        protected XmlSimpleParameter(TValue value)
        {
            this.Value = value;
        }

        [XmlText]
        public new string XmlValue
        {
            get { return this.ValueToString(this.Value); }
            set { this.Value = this.Parse(value); }
        }

        [XmlIgnore]
        public TValue Value
        {
            get { return (TValue)base.XmlValue; }
            set { base.XmlValue = value; }
        }

        protected abstract string ValueToString(TValue value);

        protected abstract TValue Parse(string text);

        protected override object ValidateXmlValue(object value)
        {
            Ensure.Argument.NotNull(value);

            if (value is string)
            {
                return this.Parse(value as string);
            }

            Ensure.Argument.True(value is TValue);
            return value;
        }
    }
}
