﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using Projects;

    public static class XmlParameterNames
    {
        public const string ActorPlayer = ProjectParameterNames.Sound.ActorPlayer;
        public const string ChannelPriority = ProjectParameterNames.Sound.ChannelPriority;
        public const string ColorIndex = ProjectParameterNames.ColorIndex;
        public const string Comment = ProjectParameterNames.Comment;
        public const string Comment1 = ProjectParameterNames.Comment1;
        public const string Comment2 = ProjectParameterNames.Comment2;
        public const string Comment3 = ProjectParameterNames.Comment3;
        public const string Comment4 = ProjectParameterNames.Comment4;
        public const string Comment5 = ProjectParameterNames.Comment5;
        public const string Comment6 = ProjectParameterNames.Comment6;
        public const string Comment7 = ProjectParameterNames.Comment7;
        public const string Comment8 = ProjectParameterNames.Comment8;
        public const string Comment9 = ProjectParameterNames.Comment9;
        public const string EnvelopeParams = ProjectParameterNames.EnvelopeParams;
        public const string FilePath = ProjectParameterNames.FilePath;
        public const string GroupItemRegisterType = ProjectParameterNames.GroupItemRegisterType;
        public const string GroupOutputType = ProjectParameterNames.Group.OutputType;
        public const string KeyGroup = ProjectParameterNames.VelocityRegion.KeyGroup;
        public const string InterpolationType = ProjectParameterNames.VelocityRegion.InterpolationType;
        public const string KeyMax = ProjectParameterNames.KeyRegion.KeyMax;
        public const string KeyMin = ProjectParameterNames.KeyRegion.KeyMin;
        public const string InstrumentEnvelopeMode = ProjectParameterNames.Instrument.EnvelopeMode;
        public const string InstrumentNoteOffMode = "InstrumentNoteOffMode";
        public const string IsEnabled = ProjectParameterNames.IsEnabled;
        public const string OriginalKey = ProjectParameterNames.VelocityRegion.OriginalKey;
        public const string Pan = ProjectParameterNames.Pan;
        public const string PanCurve = ProjectParameterNames.PanCurve;
        public const string PanMode = ProjectParameterNames.PanMode;
        public const string ProgramNo = ProjectParameterNames.Instrument.ProgramNo;
        public const string Pitch = ProjectParameterNames.Pitch;
        public const string PitchCents = ProjectParameterNames.VelocityRegion.PitchCents;
        public const string PitchSemitones = ProjectParameterNames.VelocityRegion.PitchSemitones;
        public const string PlayerHeapSize = ProjectParameterNames.Player.HeapSize;
        public const string PlayerPriority = ProjectParameterNames.Sound.PlayerPriority;
        public const string PlayerReference = ProjectParameterNames.Sound.PlayerReference;
        public const string PlayerSoundLimit = ProjectParameterNames.Player.SoundLimit;
        public const string ReleasePriorityFixed = ProjectParameterNames.Sound.ReleasePriorityFixed;
        public const string Sends = ProjectParameterNames.Sound.Sends;
        public const string SequenceSoundFileType = ProjectParameterNames.SequenceSound.FileType;
        public const string SoundSetBankReference = ProjectParameterNames.SequenceSound.SoundSetBankReference;
        public const string SoundSetBankReferences = ProjectParameterNames.SequenceSound.SoundSetBankReferences;
        public const string Sound3DParams = ProjectParameterNames.Sound.Sound3DParams;
        public const string StartPosition = ProjectParameterNames.SequenceSound.StartPosition;
        public const string SurroundPan = ProjectParameterNames.SurroundPan;
        public const string TargetItemReference = ProjectParameterNames.TargetItemReference;
        public const string UserParameter = ProjectParameterNames.Sound.UserParameter;
        public const string UserParameter1 = ProjectParameterNames.Sound.UserParameter1;
        public const string UserParameter2 = ProjectParameterNames.Sound.UserParameter2;
        public const string UserParameter3 = ProjectParameterNames.Sound.UserParameter3;
        public const string VelocityMin = ProjectParameterNames.VelocityRegion.VelocityMin;
        public const string VelocityMax = ProjectParameterNames.VelocityRegion.VelocityMax;
        public const string Volume = ProjectParameterNames.Volume;
        public const string WaveArchiveLoadType = ProjectParameterNames.WaveArchive.LoadType;
        public const string WaveArchiveReference = ProjectParameterNames.SoundSetItem.WaveArchiveReference;
        public const string WaveArchiveReferences = "WaveArchiveReferences";
        public const string WaveEncoding = ProjectParameterNames.WaveEncoding;
        public const string IsPrefetchEnabled = ProjectParameterNames.StreamSound.IsPrefetchEnabled;
        public const string IsResampleEnabled = ProjectParameterNames.IsResampleEnabled;
        public const string SampleRate = ProjectParameterNames.SampleRate;
        public const string IsDownMixEnabled = ProjectParameterNames.IsDownMixEnabled;
        public const string PreviewPlay = ProjectParameterNames.SoundSetItem.PreviewPlay;
        public const string FrontBypass = ProjectParameterNames.FrontBypass;
        public const string LPF = ProjectParameterNames.LPF;
        public const string BiquadType = ProjectParameterNames.BiquadType;
        public const string Biquad = ProjectParameterNames.Biquad;
        public const string ChannelCount = ProjectParameterNames.StreamSoundTrack.ChannelCount;
        public const string SinglePlayType = ProjectParameterNames.Sound.SinglePlayType;
        public const string SinglePlayEffectiveDuration = ProjectParameterNames.Sound.SinglePlayEffectiveDuration;

        public static class Project
        {
            public const string ProjectComment = ProjectParameterNames.Project.ProjectComment;
        }

        public static class Conversion
        {
            public const string DoWarnUnreferencedItems = ProjectParameterNames.Conversion.DoWarnUnreferencedItems;
            public const string DoWarnDisableGroupItemTargets = ProjectParameterNames.Conversion.DoWarnDisableGroupItemTargets;
            public const string DoWarnPCBinariesForAACNotFound = ProjectParameterNames.Conversion.DoWarnPCBinariesForAACNotFound;
            public const string ExcludeStringTable = ProjectParameterNames.Conversion.ExcludeStringTable;
            public const string DoOutputPCBinariesForAAC = ProjectParameterNames.Conversion.DoOutputPCBinariesForAAC;
            public const string DoUseHardwareOpusDecoder = ProjectParameterNames.Conversion.DoUseHardwareOpusDecoder;
            public const string DoDeleteGarbageOutputBinaries = ProjectParameterNames.Conversion.DoDeleteGarbageOutputBinaries;
            public const string ExternalFileDirectoryPath = ProjectParameterNames.Conversion.ExternalFileDirectoryPath;
            public const string IntermediateOutputDirectoryPath = ProjectParameterNames.Conversion.IntermediateOutputDirectoryPath;
            public const string UserManagementFileOutputDirectoryPath = ProjectParameterNames.Conversion.UserManagementFileDirectoryPath;
            public const string InGameEditCacheOutputDirectoryPath = ProjectParameterNames.Conversion.InGameEditCacheOutputDirectoryPath;
            public const string IsPreConvertCommandsEnabled = ProjectParameterNames.Conversion.IsPreConvertCommandsEnabled;
            public const string IsPostConvertCommandsEnabled = ProjectParameterNames.Conversion.IsPostConvertCommandsEnabled;
            public const string KeepIntermediateTextSequence = ProjectParameterNames.Conversion.KeepIntermediateTextSequence;
            public const string OutputLabel = ProjectParameterNames.Conversion.OutputLabel;
            public const string OutputDirectoryPath = ProjectParameterNames.Conversion.OutputDirectoryPath;
            public const string SmfTimebase = ProjectParameterNames.Conversion.SmfTimebase;
            public const string DoUseBuiltInWavePreprocessExe = ProjectParameterNames.Conversion.DoUseBuiltInWavePreprocessExe;
            public const string WavePreprocessExePath = ProjectParameterNames.Conversion.WavePreprocessExePath;
        }

        public static class FileEvent
        {
            public const string IsFileSavePreCommandEnabled = ProjectParameterNames.FileEvent.IsFileSavePreCommandEnabled;
            public const string IsFileSavePostCommandEnabled = ProjectParameterNames.FileEvent.IsFileSavePostCommandEnabled;
            public const string FileSavePreCommandPath = ProjectParameterNames.FileEvent.FileSavePreCommandPath;
            public const string FileSavePostCommandPath = ProjectParameterNames.FileEvent.FileSavePostCommandPath;
        }

        public static class Custom
        {
            public const string Bool = "Bool";
            public const string Float = "Float";
            public const string Int = "Int";
            public const string String = "String";
            public const string Uint = "Uint";
            public const string Ulong = "Ulong";
            public const string Xml = "Xml";
            public const string ItemReference = "ItemReference";
        }

        public static class Envelope
        {
            public const string Attack = "EnvelopeAttack";
            public const string Decay = "EnvelopeDecay";
            public const string Hold = "EnvelopeHold";
            public const string Release = "EnvelopeRelease";
            public const string Sustain = "EnvelopeSustain";
        }

        public static class ItemNaming
        {
            public const string BankNamePrefix = ProjectParameterNames.ItemNaming.BankNamePrefix;
            public const string CaseChange = ProjectParameterNames.ItemNaming.CaseChange;
            public const string GroupNamePrefix = ProjectParameterNames.ItemNaming.GroupNamePrefix;
            public const string HasPrefix = ProjectParameterNames.ItemNaming.HasPrefix;
            public const string InstrumentNamePrefix = ProjectParameterNames.ItemNaming.InstrumentNamePrefix;
            public const string InvalidCharChange = ProjectParameterNames.ItemNaming.InvalidCharChange;
            public const string PlayerNamePrefix = ProjectParameterNames.ItemNaming.PlayerNamePrefix;
            public const string SequenceSoundNamePrefix = ProjectParameterNames.ItemNaming.SequenceSoundNamePrefix;
            public const string SequenceSoundSetNamePrefix = ProjectParameterNames.ItemNaming.SequenceSoundSetNamePrefix;
            public const string StreamSoundNamePrefix = ProjectParameterNames.ItemNaming.StreamSoundNamePrefix;
            public const string WaveArchiveNamePrefix = ProjectParameterNames.ItemNaming.WaveArchiveNamePrefix;
            public const string WaveSoundNamePrefix = ProjectParameterNames.ItemNaming.WaveSoundNamePrefix;
            public const string WaveSoundSetNamePrefix = ProjectParameterNames.ItemNaming.WaveSoundSetNamePrefix;
            public const string ItemPastePostfix = ProjectParameterNames.ItemNaming.ItemPastePostfix;
            public const string EnabledNameDelimiter = ProjectParameterNames.ItemNaming.EnabledNameDelimiter;
            public const string NameDelimiter = ProjectParameterNames.ItemNaming.NameDelimiter;
        }

        public static class SndEdit
        {
            public const string SyncPort = ProjectParameterNames.SndEditSetting.SyncPort;
            public const string FuncPort = ProjectParameterNames.SndEditSetting.FuncPort;
            public const string CtrlPort = ProjectParameterNames.SndEditSetting.CtrlPort;

            public const string SyncChannel = ProjectParameterNames.SndEditSetting.SyncChannel;
            public const string FuncChannel = ProjectParameterNames.SndEditSetting.FuncChannel;
            public const string CtrlChannel = ProjectParameterNames.SndEditSetting.CtrlChannel;
        }

        public static class Connection
        {
            public const string TimeOut = ProjectParameterNames.Connection.ConnectionTimeOut;
        }

        public static class SoundArchivePlayer
        {
            public const string SequenceSoundCount = ProjectParameterNames.SoundArchivePlayer.SequenceSoundCount;
            public const string SequenceTrackCount = ProjectParameterNames.SoundArchivePlayer.SequenceTrackCount;
            public const string StreamChannelCount = ProjectParameterNames.SoundArchivePlayer.StreamChannelCount;
            public const string StreamBufferTimes = ProjectParameterNames.SoundArchivePlayer.StreamBufferTimes;
            public const string StreamSoundCount = ProjectParameterNames.SoundArchivePlayer.StreamSoundCount;
            public const string WaveSoundCount = ProjectParameterNames.SoundArchivePlayer.WaveSoundCount;
        }

        public static class CommentColumnText
        {
            public const string Comment = "CommentColumnText";
            public const string Comment1 = "Comment1ColumnText";
            public const string Comment2 = "Comment2ColumnText";
            public const string Comment3 = "Comment3ColumnText";
            public const string Comment4 = "Comment4ColumnText";
            public const string Comment5 = "Comment5ColumnText";
            public const string Comment6 = "Comment6ColumnText";
            public const string Comment7 = "Comment7ColumnText";
            public const string Comment8 = "Comment8ColumnText";
            public const string Comment9 = "Comment9ColumnText";
        }

        public static class ColorComment
        {
            public const string Comment0 = "ColorComment0";
            public const string Comment1 = "ColorComment1";
            public const string Comment2 = "ColorComment2";
            public const string Comment3 = "ColorComment3";
            public const string Comment4 = "ColorComment4";
            public const string Comment5 = "ColorComment5";
            public const string Comment6 = "ColorComment6";
            public const string Comment7 = "ColorComment7";
            public const string Comment8 = "ColorComment8";
        }

        public static class SoundList
        {
            public const string Title = "SoundListTitle";
        }

        public static class Sound3D
        {
            public const string DecayCurve3D = "DecayCurve3D";
            public const string DecayRatio3D = "DecayRatio3D";
            public const string DopplerFactor3D = "DopplerFactor3D";
            public const string Enable3DFilter = "Enable3DFilter";
            public const string Enable3DPan = "Enable3DPan";
            public const string Enable3DPriority = "Enable3DPriority";
            public const string Enable3DSurroundPan = "Enable3DSurroundPan";
            public const string Enable3DVolume = "Enable3DVolume";
        }

        public static class Statistics
        {
            public const string EnabledIntegratedLoudnessThreshold = "EnabledIntegratedLoudnessThreshold";
            public const string IntegratedLoudnessThreshold = "IntegratedLoudnessThreshold";
            public const string SequenceMaxMeasureDuration = "SequenceMaxMeasureDuration";
        }
    }
}
